package com.ejianc.business.kingdee.controller;

import com.ejianc.business.kingdee.base.vo.save.*;
import com.ejianc.business.kingdee.service.KingDeeGalaxyVoucherService;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherApiQueryVO;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: KingDeeGalaxyVoucherController
 * @author songlx
 * @date 2023/12/13
 * @version 1.0
 */
@RestController
@RequestMapping("kingDeeGalaxyVoucher")
@Api(value = "金蝶云星空-凭证", tags = {"金蝶云星空-凭证"})
public class KingDeeGalaxyVoucherController implements Serializable {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private KingDeeGalaxyVoucherService kingDeeGalaxyVoucherService;

    @ApiOperation("保存凭证")
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public CommonResponse save(@RequestBody KingDeeVoucherApiSaveVO<Model> kingDeeVoucherApiSaveVO) {
        VoucherParams voucherParams = new VoucherParams();
      /*  KingDeeVoucherApiSaveVO<Model> data = new KingDeeVoucherApiSaveVO<>();
        Model model = this.getModel("保存测试01", 888);
        data.setModel(model);
        voucherParams.setFinanceVoucher(GsonUtil.objToMap(data));
        */

        voucherParams.setFinanceVoucher(DataConvertUtil.objToMap(kingDeeVoucherApiSaveVO));
        return kingDeeGalaxyVoucherService.save(voucherParams);
    }


    @ApiOperation("批量保存凭证")
    @RequestMapping(value = "/batchSave", method = RequestMethod.POST)
    public CommonResponse batchSave(@RequestBody KingDeeVoucherApiSaveVO<List<Model>> kingDeeVoucherApiSaveVO) {
        VoucherParams voucherParams = new VoucherParams();
     /*   KingDeeVoucherApiSaveVO<List<Model>> data = new KingDeeVoucherApiSaveVO<>();
        Model model = this.getModel("批量保存测试1", 256);
        Model model2 = this.getModel("批量保存测试2", 1024);
        data.setModel(Arrays.asList(model, model2));
        voucherParams.setFinanceVoucher(GsonUtil.objToMap(data));*/

        voucherParams.setFinanceVoucher(DataConvertUtil.objToMap(kingDeeVoucherApiSaveVO));
        return kingDeeGalaxyVoucherService.batchSave(voucherParams);
    }

    private Model getModel(String b, int a) {
        Model model = new Model();
        FAccountBookID _FAccountBookID = new FAccountBookID();
        _FAccountBookID.setFNumber("S01");
        model.setFAccountBookID(_FAccountBookID);
        model.setFDate("2023-12-15");
        model.setFDocumentStatus("Z");


        FVOUCHERGROUPID _FVOUCHERGROUPID = new FVOUCHERGROUPID();
        _FVOUCHERGROUPID.setFNumber("PRE001");
        model.setFVOUCHERGROUPID(_FVOUCHERGROUPID);

        List<FEntity> _FEntity = new ArrayList<>();


        FEntity sub1 = new FEntity();

        sub1.setFEXPLANATION(b);
        //科目编码
        FACCOUNTID _FACCOUNTID = new FACCOUNTID();
        _FACCOUNTID.setFNumber("2202.02");
        sub1.setFACCOUNTID(_FACCOUNTID);

        //币别
        FCURRENCYID _FCURRENCYID = new FCURRENCYID();
        _FCURRENCYID.setFNumber("PRE001");
        sub1.setFCURRENCYID(_FCURRENCYID);

        //汇率类型
        FEXCHANGERATETYPE _FEXCHANGERATETYPE = new FEXCHANGERATETYPE();
        _FEXCHANGERATETYPE.setFNumber("HLTX01_SYS");
        sub1.setFEXCHANGERATETYPE(_FEXCHANGERATETYPE);
        sub1.setFEXCHANGERATE(1);
        sub1.setFAMOUNTFOR(a);
        sub1.setFDEBIT(a);

        //核算对象
        Map _FDetailID = new HashMap<String, FDetailID>();
        FDetailID _FDETAILID__FFLEX = new FDetailID();
        _FDETAILID__FFLEX.setFNumber("1.001");
        _FDetailID.put("FDETAILID__FFLEX4", _FDETAILID__FFLEX);
        sub1.setFDetailID(_FDetailID);


        FEntity sub2 = new FEntity();
        sub2.setFEXPLANATION(b);
        //科目编码
        FACCOUNTID _FACCOUNTID2 = new FACCOUNTID();
        _FACCOUNTID2.setFNumber("1001.01");
        sub2.setFACCOUNTID(_FACCOUNTID2);

        //币别
        FCURRENCYID _FCURRENCYID2 = new FCURRENCYID();
        _FCURRENCYID2.setFNumber("PRE001");
        sub2.setFCURRENCYID(_FCURRENCYID2);

        //汇率类型
        FEXCHANGERATETYPE _FEXCHANGERATETYPE2 = new FEXCHANGERATETYPE();
        _FEXCHANGERATETYPE2.setFNumber("HLTX01_SYS");
        sub2.setFEXCHANGERATETYPE(_FEXCHANGERATETYPE2);

        sub2.setFEXCHANGERATE(1);

        sub2.setFAMOUNTFOR(a);
        sub2.setFCREDIT(a);

        _FEntity.add(sub1);
        _FEntity.add(sub2);
        model.setFEntity(_FEntity);
        return model;
    }


    @ApiOperation("查询凭证")
    @RequestMapping(value = "/get", method = RequestMethod.POST)
    public CommonResponse get(@RequestBody VoucherInfo voucherInfo) {
        return kingDeeGalaxyVoucherService.get(voucherInfo);
    }

    @ApiOperation("查询单个凭证列表")
    @RequestMapping(value = "/getOne", method = RequestMethod.POST)
    public CommonResponse getOne(@RequestBody VoucherApiQueryVO voucherApiQueryVO) {
        return kingDeeGalaxyVoucherService.getOne(voucherApiQueryVO);
    }


    @ApiOperation("删除凭证")
    @RequestMapping(value = "/del", method = RequestMethod.POST)
    public CommonResponse del(@RequestBody VoucherInfo voucherInfo) {
        return kingDeeGalaxyVoucherService.del(voucherInfo);
    }


}
