/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.accplat.originvoucher.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.originvoucher.bean.OriginVoucherEntity;
import com.ejianc.business.accplat.originvoucher.service.IOriginVoucherService;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherEntryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"originVoucher"})
@Api(value="\u539f\u59cb\u51ed\u8bc1", tags={"\u539f\u59cb\u51ed\u8bc1"})
public class OriginVoucherController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ORIGN_VOUCHER_CODE";
    @Autowired
    private IOriginVoucherService service;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u4e1a\u52a1\u5355\u636e\u8054\u67e5\u539f\u59cb\u51ed\u8bc1\u5217\u8868")
    @RequestMapping(value={"/get"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<OriginVoucherVO>> get(@RequestBody VoucherInfo voucherInfo) {
        Long billId = voucherInfo.getBillId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OriginVoucherEntity::getSrcBillId, (Object)billId);
        List list = this.service.list((Wrapper)wrapper);
        if (list != null && list.size() == 1) {
            Long id = ((OriginVoucherEntity)((Object)list.get(0))).getId();
            CommonResponse<OriginVoucherVO> one = this.getOne(id);
            return CommonResponse.success((String)"\u4e1a\u52a1\u5355\u636e\u8054\u67e5\u539f\u59cb\u51ed\u8bc1\u6210\u529f\uff01", Arrays.asList((OriginVoucherVO)one.getData()));
        }
        List originVoucherVOS = BeanMapper.mapList((Iterable)list, OriginVoucherVO.class);
        return CommonResponse.success((String)"\u4e1a\u52a1\u5355\u636e\u8054\u67e5\u539f\u59cb\u51ed\u8bc1\u6210\u529f\uff01", (Object)originVoucherVOS);
    }

    @ApiOperation(value="\u4e1a\u52a1\u5355\u636e\u8054\u67e5\u5355\u4e2a\u539f\u59cb\u51ed\u8bc1")
    @RequestMapping(value={"/getOne"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OriginVoucherVO> getOne(@RequestParam Long id) {
        OriginVoucherEntity entity = (OriginVoucherEntity)((Object)this.service.selectById(id));
        OriginVoucherVO vo = (OriginVoucherVO)BeanMapper.map((Object)((Object)entity), OriginVoucherVO.class);
        List originVoucherEntryList = vo.getOriginVoucherEntryList();
        Collections.sort(originVoucherEntryList, Comparator.comparing(OriginVoucherEntryVO::getDirectionFlag).reversed());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OriginVoucherVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OriginVoucherVO saveOrUpdateVO) {
        OriginVoucherEntity entity = (OriginVoucherEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OriginVoucherEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setVoucherCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        OriginVoucherVO vo = (OriginVoucherVO)BeanMapper.map((Object)((Object)entity), OriginVoucherVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OriginVoucherVO> queryDetail(@RequestParam Long id) {
        OriginVoucherEntity entity = (OriginVoucherEntity)((Object)this.service.selectById(id));
        OriginVoucherVO vo = (OriginVoucherVO)BeanMapper.map((Object)((Object)entity), OriginVoucherVO.class);
        List originVoucherEntryList = vo.getOriginVoucherEntryList();
        Collections.sort(originVoucherEntryList, Comparator.comparing(OriginVoucherEntryVO::getDirectionFlag).reversed());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OriginVoucherVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OriginVoucherVO originVoucherVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OriginVoucherVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("voucherCode", "accbookName", "srcBillCode", "srcBillTypeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OriginVoucherVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("voucherCode", "accbookName", "srcBillCode", "srcBillTypeName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OriginVoucher-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refOriginVoucherData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OriginVoucherVO>> refOriginVoucherData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OriginVoucherVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

