/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.yonyou.base.module.token;

import com.ejianc.business.yonyou.base.module.common.OpenApiAccessToken;
import com.ejianc.business.yonyou.base.module.token.OpenApiTokenCacheProvider;
import com.ejianc.framework.cache.redis.CacheManager;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpenApiTokenCacheProviderImpl
implements OpenApiTokenCacheProvider {
    private final String CACHE_PREFIX = "yonyouystoken:";
    @Autowired
    private CacheManager cacheManager;

    @Override
    public OpenApiAccessToken loadTokenFromCache(String tenantId) {
        String cacheKey = this.getCacheKey(tenantId);
        OpenApiAccessToken token = (OpenApiAccessToken)this.cacheManager.get(cacheKey);
        if (token != null && token.expired()) {
            token = null;
        }
        return token;
    }

    @Override
    public void saveTokenToCache(String tenantId, OpenApiAccessToken token) {
        this.cacheManager.set(this.getCacheKey(tenantId), (Serializable)token);
    }

    private String getCacheKey(String tenantId) {
        return "yonyouystoken:" + tenantId;
    }
}

