package com.ejianc.business.accplat.originvoucher.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.originvoucher.bean.OriginVoucherEntity;
import com.ejianc.business.accplat.originvoucher.service.IOriginVoucherService;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherEntryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 原始凭证
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("originVoucher")
@Api(value = "原始凭证", tags = {"原始凭证"})
public class OriginVoucherController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ORIGN_VOUCHER_CODE";

    @Autowired
    private IOriginVoucherService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("业务单据联查原始凭证列表")
    @RequestMapping(value = "/get", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<OriginVoucherVO>> get(@RequestBody VoucherInfo voucherInfo) {
        Long billId = voucherInfo.getBillId();
        LambdaQueryWrapper<OriginVoucherEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OriginVoucherEntity::getSrcBillId, billId);
        List<OriginVoucherEntity> list = service.list(wrapper);
        if (list != null && list.size() == 1) {
            Long id = list.get(0).getId();
            CommonResponse<OriginVoucherVO> one = this.getOne(id);
            return CommonResponse.success("业务单据联查原始凭证成功！", Arrays.asList(one.getData()));
        }
        List<OriginVoucherVO> originVoucherVOS = BeanMapper.mapList(list, OriginVoucherVO.class);
        return CommonResponse.success("业务单据联查原始凭证成功！", originVoucherVOS);
    }


    @ApiOperation("业务单据联查单个原始凭证")
    @RequestMapping(value = "/getOne", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OriginVoucherVO> getOne(@RequestParam Long id) {
        OriginVoucherEntity entity = service.selectById(id);
        OriginVoucherVO vo = BeanMapper.map(entity, OriginVoucherVO.class);
        List<OriginVoucherEntryVO> originVoucherEntryList = vo.getOriginVoucherEntryList();
        Collections.sort(originVoucherEntryList, Comparator.comparing(OriginVoucherEntryVO::getDirectionFlag).reversed());
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OriginVoucherVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody OriginVoucherVO saveOrUpdateVO) {
        OriginVoucherEntity entity = BeanMapper.map(saveOrUpdateVO, OriginVoucherEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setVoucherCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        OriginVoucherVO vo = BeanMapper.map(entity, OriginVoucherVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OriginVoucherVO> queryDetail(@RequestParam Long id) {
        OriginVoucherEntity entity = service.selectById(id);
        OriginVoucherVO vo = BeanMapper.map(entity, OriginVoucherVO.class);
        List<OriginVoucherEntryVO> originVoucherEntryList = vo.getOriginVoucherEntryList();
        Collections.sort(originVoucherEntryList, Comparator.comparing(OriginVoucherEntryVO::getDirectionFlag).reversed());
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OriginVoucherVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OriginVoucherVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OriginVoucherVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OriginVoucherVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("voucherCode", "accbookName", "srcBillCode", "srcBillTypeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<OriginVoucherEntity> page = service.queryPage(param, false);
        IPage<OriginVoucherVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OriginVoucherVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("voucherCode", "accbookName", "srcBillCode", "srcBillTypeName"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<OriginVoucherEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OriginVoucher-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refOriginVoucherData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OriginVoucherVO>> refOriginVoucherData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OriginVoucherEntity> page = service.queryPage(param, false);
        IPage<OriginVoucherVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OriginVoucherVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
