package com.ejianc.business.accplat.originvoucher.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.originvoucher.bean.VoucherTemplateEntity;
import com.ejianc.business.accplat.originvoucher.service.IVoucherTemplateService;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 凭证模板
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("voucherTemplate")
@Api(value = "凭证模板", tags = {"凭证模板"})
public class VoucherTemplateController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "VOUCHER_TEMPLATE_CODE";

    @Autowired
    private IVoucherTemplateService service;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<VoucherTemplateVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody VoucherTemplateVO saveOrUpdateVO) {
        String businessType = saveOrUpdateVO.getBusinessType();
        LambdaQueryWrapper<VoucherTemplateEntity> templateEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
        templateEntityLambdaQueryWrapper.eq(VoucherTemplateEntity::getTenantId, InvocationInfoProxy.getTenantid());
        templateEntityLambdaQueryWrapper.eq(VoucherTemplateEntity::getSrcBillTypeCode, saveOrUpdateVO.getSrcBillTypeCode());
        if (StringUtils.isNotBlank(businessType)) {
            templateEntityLambdaQueryWrapper.eq(VoucherTemplateEntity::getBusinessType, businessType);
        } else {
            templateEntityLambdaQueryWrapper.isNull(VoucherTemplateEntity::getBusinessType);
        }
        templateEntityLambdaQueryWrapper.ne(saveOrUpdateVO.getId() != null, VoucherTemplateEntity::getId, saveOrUpdateVO.getId());
        int count = service.count(templateEntityLambdaQueryWrapper);
        if (count > 0) {
            throw new BusinessException("该单据类型【单据类型：" + saveOrUpdateVO.getSrcBillTypeName() + (StringUtils.isEmpty(businessType) ? "" : "、业务类型：" + businessType) + "】的凭证模板已存在！");
        }
        VoucherTemplateEntity entity = BeanMapper.map(saveOrUpdateVO, VoucherTemplateEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setTemplateCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        VoucherTemplateVO vo = BeanMapper.map(entity, VoucherTemplateVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<VoucherTemplateVO> queryDetail(@RequestParam Long id) {
        VoucherTemplateEntity entity = service.selectById(id);
        VoucherTemplateVO vo = BeanMapper.map(entity, VoucherTemplateVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<VoucherTemplateVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (VoucherTemplateVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(VoucherTemplateVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<VoucherTemplateVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<VoucherTemplateEntity> page = service.queryPage(param, false);
        IPage<VoucherTemplateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), VoucherTemplateVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<VoucherTemplateEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("VoucherTemplate-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refVoucherTemplateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<VoucherTemplateVO>> refVoucherTemplateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<VoucherTemplateEntity> page = service.queryPage(param, false);
        IPage<VoucherTemplateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), VoucherTemplateVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
