package com.ejianc.business.accplat.originvoucher.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.originvoucher.bean.VoucherTemplateEntity;
import com.ejianc.business.accplat.originvoucher.mapper.VoucherTemplateMapper;
import com.ejianc.business.accplat.originvoucher.service.IVoucherTemplateService;
import com.ejianc.business.accplat.originvoucher.vo.VoucherTemplateVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * 凭证模板
 *
 * @author generator
 *
 */
@Service("voucherTemplateService")
public class VoucherTemplateServiceImpl extends BaseServiceImpl<VoucherTemplateMapper, VoucherTemplateEntity> implements IVoucherTemplateService {

    @Override
    public VoucherTemplateVO getVoucherTemplate(Long accbookId, String billTypeCode, String businessType) {
        LambdaQueryWrapper<VoucherTemplateEntity> templateEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
        templateEntityLambdaQueryWrapper.eq(VoucherTemplateEntity::getTenantId, InvocationInfoProxy.getTenantid());
        templateEntityLambdaQueryWrapper.eq(VoucherTemplateEntity::getAccbookId, accbookId);
        templateEntityLambdaQueryWrapper.eq(VoucherTemplateEntity::getSrcBillTypeCode, billTypeCode);
        if (StringUtils.isNotBlank(businessType)) {
            templateEntityLambdaQueryWrapper.eq(VoucherTemplateEntity::getBusinessType, businessType);
        } else {
            templateEntityLambdaQueryWrapper.isNull(VoucherTemplateEntity::getBusinessType);
        }
        VoucherTemplateEntity templateEntity = this.getOne(templateEntityLambdaQueryWrapper);
        if (templateEntity == null) {
            throw new BusinessException("未查询到单据【单据类型：" + billTypeCode + (StringUtils.isNotBlank(businessType) ? "，业务类型：" + businessType : "") + "】的凭证模板!");
        }
        templateEntity = this.selectById(templateEntity.getId());
        return BeanMapper.map(templateEntity, VoucherTemplateVO.class);
    }

}
