package com.ejianc.business.yonyou.base.module.auth;

import com.ejianc.business.yonyou.base.module.auth.isv.ISVAuthProvider;
import com.ejianc.business.yonyou.base.module.auth.tenant.TenantAuthProvider;
import com.ejianc.business.yonyou.base.properties.UCFCoreProperties;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * 本类主要用于
 *
 * @author liuhaoi
 * @since Created At 2020/10/22 0022 19:03
 */
@Slf4j
@RequiredArgsConstructor
public class OpenApiAuthProviderFactoryImpl implements OpenApiAuthProviderFactory {

    private final ISVAuthProvider isvAuthProvider;

    private final TenantAuthProvider tenantAuthProvider;

    @Resource
    private UCFCoreProperties properties;

    @Override
    public OpenApiAuthProvider getAuthProvider() {
        return properties.getAccessType()?isvAuthProvider:tenantAuthProvider;
    }



}
