package com.ejianc.business.accplat.config.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.accplat.config.bean.AccbookEntity;
import com.ejianc.business.accplat.config.mapper.AccbookMapper;
import com.ejianc.business.accplat.config.service.IAccbookService;
import com.ejianc.business.accplat.config.vo.AccbookVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 账簿
 *
 * @author generator
 *
 */
@Service("accbookService")
public class AccbookServiceImpl extends BaseServiceImpl<AccbookMapper, AccbookEntity> implements IAccbookService {

    @Override
    public AccbookVO getOneByCode(String code) {
        LambdaQueryWrapper<AccbookEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AccbookEntity::getTenantId, InvocationInfoProxy.getTenantid());
        wrapper.eq(AccbookEntity::getCode, code);
        wrapper.eq(AccbookEntity::getEnabled, 1);
        AccbookEntity accbookEntity = this.getOne(wrapper);
        if (accbookEntity == null) {
            throw new BusinessException("账簿【编码：" + code + "】不存在！");
        }
        return BeanMapper.map(accbookEntity, AccbookVO.class);
    }
}
