package com.ejianc.business.accplat.originvoucher.service.impl;

import com.ejianc.business.accplat.originvoucher.bean.OriginVoucherAuxiliaryEntity;
import com.ejianc.business.accplat.originvoucher.bean.OriginVoucherEntity;
import com.ejianc.business.accplat.originvoucher.mapper.OriginVoucherMapper;
import com.ejianc.business.accplat.originvoucher.service.IOriginVoucherService;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherAuxiliaryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherEntryVO;
import com.ejianc.business.accplat.originvoucher.vo.OriginVoucherVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 原始凭证
 *
 * @author generator
 *
 */
@Service("originVoucherService")
public class OriginVoucherServiceImpl extends BaseServiceImpl<OriginVoucherMapper, OriginVoucherEntity> implements IOriginVoucherService {

    @Autowired
    private IBillCodeApi billCodeApi;


    private static final String BILL_CODE = "ORIGN_VOUCHER_CODE";

    @Override
    public void saveOriginVouchers(List<OriginVoucherVO> originVoucherVOS) {
        for (OriginVoucherVO originVoucherVO : originVoucherVOS) {
            originVoucherVO.setId(IdWorker.getId());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), originVoucherVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                originVoucherVO.setVoucherCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            List<OriginVoucherAuxiliaryEntity> originVoucherAuxiliaryList = new ArrayList<>();
            List<OriginVoucherEntryVO> originVoucherEntryList = originVoucherVO.getOriginVoucherEntryList();
            if (CollectionUtils.isNotEmpty(originVoucherEntryList)) {
                for (OriginVoucherEntryVO originVoucherEntryVO : originVoucherEntryList) {
                    originVoucherEntryVO.setId(IdWorker.getId());
                    List<OriginVoucherAuxiliaryVO> originVoucherAuxiliaryVOList = originVoucherEntryVO.getOriginVoucherAuxiliaryVOList();
                    if (CollectionUtils.isNotEmpty(originVoucherAuxiliaryVOList)) {
                        for (OriginVoucherAuxiliaryVO auxiliaryVO : originVoucherAuxiliaryVOList) {
                            auxiliaryVO.setEntryId(originVoucherEntryVO.getId());
                            auxiliaryVO.setOriginVoucherId(originVoucherVO.getId());
                            originVoucherAuxiliaryList.add(BeanMapper.map(auxiliaryVO, OriginVoucherAuxiliaryEntity.class));
                        }
                    }
                }
            }
            OriginVoucherEntity entity = BeanMapper.map(originVoucherVO, OriginVoucherEntity.class);
            if (CollectionUtils.isNotEmpty(originVoucherAuxiliaryList)) {
                entity.setOriginVoucherAuxiliaryList(originVoucherAuxiliaryList);
            }
            this.saveOrUpdate(entity, false);
        }
    }
}
