package com.ejianc.business.yonyou.api.customer;

import com.ejianc.business.yonyou.base.module.reponse.ApiDataResponse;
import com.ejianc.business.yonyou.base.module.reponse.ApiStringDataResonse;
import com.ejianc.business.yonyou.api.BaseOpenApi;
import com.ejianc.business.yonyou.api.OpenApiURL;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @description: 用友客户档案开放平台接口
 * @author: nishch
 * @create: 2021-07-08
 **/
@Component
public class CustomerApi extends BaseOpenApi {

    public Map<String, Object> save(Map<String, Object> params) {
        ApiDataResponse apiDataResponse =  postForEntity(OpenApiURL.CUSTOMER_SAVE,params, ApiDataResponse.class,true);
        return getData(apiDataResponse);
    }

    public Map<String, Object> detail(Map<String, String> params) {
        ApiDataResponse apiDataResponse =  getForEntity(OpenApiURL.CUSTOMER_DETAIL,params, ApiDataResponse.class);
        return getData(apiDataResponse);
    }

    public Map<String, Object> list(Map<String, Object> params) {
        ApiDataResponse apiDataResponse =  postForEntity(OpenApiURL.CUSTOMER_LIST,params, ApiDataResponse.class);
        return getData(apiDataResponse);
    }

    public Map<String, Object> assign(Map<String, Object> params) {
        ApiDataResponse apiDataResponse =  postForEntity(OpenApiURL.CUSTOMER_ASSIGN_ORG,params, ApiDataResponse.class);
        return getData(apiDataResponse);
    }
    public String batchDelete(Map<String, Object> params) {
        ApiStringDataResonse apiDataResponse =  postForEntity(OpenApiURL.CUSTOMER_BATCHDEL,params, ApiStringDataResonse.class);
        return getData(apiDataResponse);
    }

}
