package com.ejianc.business.yonyou.base.properties;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author liuhaoi
 */
@Data
@Component
@ConfigurationProperties(prefix = UCFCoreProperties.UNIVERSAL_PREFIX)
public class UCFCoreProperties {

    public static final String UNIVERSAL_PREFIX = "ucf.mdd";

    /**
     * 应用名称
     */
    @Value("${vcap.application.name:${spring.application.name:${spring.config.name:application}}}")
    private String applicationName;

    private String ssoYhtUrl;

    private String ssoYsUrl;

    private String orderDealWay;

    private String defaultTenantId;

    private boolean accessType;

    public boolean getAccessType() {
        return accessType;
    }
}
