/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.foundation.ai.utils.QianfanAppBuilderUtil;
import com.ejianc.foundation.ai.utils.QianfanUtils;
import com.ejianc.foundation.ai.utils.ThreadPoolUtils;
import com.ejianc.foundation.ai.vo.receipt.AiReceiptResultVO;
import com.ejianc.foundation.ai.vo.receipt.AiReceiptVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="receiptAiService")
public class ReceiptAiService {
    private static final Logger logger = LoggerFactory.getLogger(QianfanAppBuilderUtil.class);
    @Autowired
    private IMaterialApi materialApi;
    private final String CACHE_PREFIX = "receiptAiFileId:";
    @Autowired
    private CacheManager cacheManager;

    public AiReceiptResultVO getResultFromCache(String fileId) {
        String cacheKey = this.getCacheKey(fileId);
        return (AiReceiptResultVO)this.cacheManager.get(cacheKey);
    }

    public void saveResultToCache(AiReceiptResultVO receiptResultVO) {
        this.cacheManager.set(this.getCacheKey(receiptResultVO.getFileId()), (Serializable)receiptResultVO);
    }

    private String getCacheKey(String tenantId) {
        return "receiptAiFileId:" + tenantId;
    }

    public void identifyMaterial(AiReceiptResultVO resultVO, String appId, String secretKey) {
        logger.info(JSONObject.toJSONString((Object)resultVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        try {
            CommonResponse materialByIds;
            List receiptVOS = resultVO.getReceiptVOS();
            ThreadPoolUtils threadPoolUtils = ThreadPoolUtils.getInstance();
            HashMap<String, Object> futureMap = new HashMap<String, Object>();
            String tenantid = InvocationInfoProxy.getTenantid().toString();
            for (AiReceiptVO aiReceiptVO : receiptVOS) {
                if (futureMap.containsKey(aiReceiptVO.getKey())) continue;
                Future future = threadPoolUtils.runTask(() -> {
                    StringBuilder content = new StringBuilder();
                    content.append("\u5728\u77e5\u8bc6\u5e93\u4e2d\u67e5\u627e\u4e00\u6761" + tenantid + aiReceiptVO.getKey() + "\u7684\u6574\u6761\u6570\u636e\uff0c\u7ed3\u679c\u5f3a\u5236\u4f7f\u7528JSON\u5bf9\u8c61\u8fd4\u56de\u3002");
                    logger.info(content.toString());
                    return QianfanUtils.postChatMsg(content.toString(), appId, secretKey);
                });
                futureMap.put(aiReceiptVO.getKey(), future);
            }
            HashMap<String, MaterialVO> aiMaterialMap = new HashMap<String, MaterialVO>();
            ArrayList<Long> materialIds = new ArrayList<Long>();
            for (String key : futureMap.keySet()) {
                Future future = (Future)futureMap.get(key);
                try {
                    String result = (String)future.get();
                    JSONObject qFanContent = JSON.parseObject((String)result);
                    String answer = qFanContent.getString("answer");
                    logger.info("\u8bf7\u6c42 id={},\u8fd4\u56deanswer={}", (Object)key, (Object)answer);
                    if (!StringUtils.isNotBlank((String)answer) || !answer.contains("```json")) continue;
                    answer = answer.split("```json")[1];
                    JSONObject jsonObject = JSON.parseObject((String)(answer = answer.split("```")[0]));
                    Long materialId = jsonObject.getLong("\u7269\u6599ID");
                    if (materialId == null) continue;
                    materialIds.add(materialId);
                    MaterialVO aiMaterialVO = new MaterialVO();
                    aiMaterialVO.setCategoryId(jsonObject.getLong("\u7269\u6599\u5206\u7c7bID"));
                    aiMaterialVO.setCategoryName(jsonObject.getString("\u7269\u6599\u5206\u7c7b"));
                    aiMaterialVO.setId(materialId);
                    aiMaterialVO.setCode(jsonObject.getString("\u7269\u6599\u7f16\u7801"));
                    aiMaterialVO.setName(jsonObject.getString("\u7269\u6599\u540d\u79f0"));
                    aiMaterialVO.setSpec(jsonObject.getString("\u89c4\u683c\u578b\u53f7"));
                    aiMaterialVO.setUnitName(jsonObject.getString("\u8ba1\u91cf\u5355\u4f4d"));
                    aiMaterialVO.setTenantId(jsonObject.containsKey((Object)"\u79df\u6237ID") ? jsonObject.getLong("\u79df\u6237ID") : null);
                    aiMaterialMap.put(key, aiMaterialVO);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            HashMap<Long, MaterialVO> materialVOMap = new HashMap<Long, MaterialVO>();
            if (CollectionUtils.isNotEmpty(materialIds) && (materialByIds = this.materialApi.queryMaterialByIds(materialIds)).isSuccess() && materialByIds.getData() != null) {
                for (MaterialVO datum : (List)materialByIds.getData()) {
                    materialVOMap.put(datum.getId(), datum);
                }
            }
            if (!materialVOMap.isEmpty()) {
                for (AiReceiptVO aiReceiptVO : receiptVOS) {
                    MaterialVO materialVO = (MaterialVO)aiMaterialMap.get(aiReceiptVO.getKey());
                    if (materialVO == null || materialVO.getId() == null || materialVOMap.get(materialVO.getId()) == null) continue;
                    MaterialVO resVO = (MaterialVO)materialVOMap.get(materialVO.getId());
                    aiReceiptVO.setCategoryId(resVO.getCategoryId());
                    aiReceiptVO.setCategoryName(resVO.getCategoryName());
                    aiReceiptVO.setId(resVO.getId());
                    aiReceiptVO.setCode(resVO.getCode());
                    aiReceiptVO.setName(resVO.getName());
                    aiReceiptVO.setSpec(resVO.getSpec());
                    aiReceiptVO.setUnitName(resVO.getUnitName());
                    aiReceiptVO.setTenantId(resVO.getTenantId());
                }
            }
            resultVO.setCode(Integer.valueOf(2));
            resultVO.setMsg(null);
            resultVO.setReceiptVOS(receiptVOS);
            this.saveResultToCache(resultVO);
            logger.info("=================\u5339\u914d\u7269\u8d44\u5e93\u7ed3\u679c===========================");
            logger.info(JSONObject.toJSONString((Object)resultVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            logger.info("==============================================");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

