/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QianfanAppBuilderUtil {
    private static final Logger logger = LoggerFactory.getLogger(QianfanAppBuilderUtil.class);
    private static final MediaType mediaType = MediaType.parse((String)"application/json");
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.MINUTES).readTimeout(10L, TimeUnit.MINUTES).writeTimeout(10L, TimeUnit.MINUTES).build();
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");

    public static String postChatMsg(JSONObject msgBody, String AppBuilderAppID, String AppBuilderSecretKey) {
        try {
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)msgBody.toJSONString());
            Request request = new Request.Builder().url("https://qianfan.baidubce.com/v2/app/conversation/runs").method("POST", body).addHeader("Content-Type", "application/json;charset=utf-8").addHeader("X-Appbuilder-Authorization", AppBuilderSecretKey).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            String resBody = response.body().string();
            return resBody;
        }
        catch (Exception e) {
            logger.error("\u767e\u5ea6\u5927\u6a21\u578b\u5bf9\u8bdd\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static String getNewConversationId(String appBuilderAppID, String appBuilderSecretKey) {
        try {
            JSONObject msgBody = new JSONObject();
            msgBody.put("app_id", (Object)appBuilderAppID);
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)msgBody.toJSONString());
            Request request = new Request.Builder().url("https://qianfan.baidubce.com/v2/app/conversation").method("POST", body).addHeader("Content-Type", "application/json").addHeader("X-Appbuilder-Authorization", appBuilderSecretKey).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject resBody = JSON.parseObject((String)response.body().string());
            return resBody.getString("conversation_id");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String uploadLocalFile(String appId, String secretKey, String conversationId, String imageUrl, String imageName) {
        String formattedDate = sdf.format(new Date());
        String savePath = QianfanAppBuilderUtil.class.getClassLoader().getResource("").getPath() + "/receiptAiImage/" + formattedDate + "_" + imageName;
        try {
            URL url = new URL(imageUrl);
            BufferedImage image = ImageIO.read(url);
            File file = new File(savePath);
            File parentDir = file.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!file.exists()) {
                ImageIO.write((RenderedImage)image, FilenameUtils.getExtension((String)imageName), file);
            }
            MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("app_id", appId).addFormDataPart("file", imageName, RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file)).addFormDataPart("conversation_id", conversationId).build();
            Request request = new Request.Builder().url("https://qianfan.baidubce.com/v2/app/conversation/file/upload").method("POST", (RequestBody)body).addHeader("Content-Type", "multipart/form-data").addHeader("X-Appbuilder-Authorization", secretKey).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject qFanContent = JSON.parseObject((String)response.body().string());
            return qFanContent.getString("id");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

