/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QianfanUtils {
    private static final Logger logger = LoggerFactory.getLogger(QianfanUtils.class);
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.MINUTES).readTimeout(10L, TimeUnit.MINUTES).writeTimeout(10L, TimeUnit.MINUTES).build();
    private static final MediaType mediaType = MediaType.parse((String)"application/json");

    public static String postChatMsg(String content, String AppBuilderAppID, String AppBuilderSecretKey) {
        try {
            String conversationId = QianfanUtils.getNewConversationId(AppBuilderAppID, AppBuilderSecretKey);
            JSONObject msgBody = new JSONObject();
            msgBody.put("app_id", (Object)AppBuilderAppID);
            msgBody.put("query", (Object)content);
            msgBody.put("stream", (Object)false);
            msgBody.put("conversation_id", (Object)conversationId);
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)msgBody.toJSONString());
            Request request = new Request.Builder().url("https://qianfan.baidubce.com/v2/app/conversation/runs").method("POST", body).addHeader("Content-Type", "application/json;charset=utf-8").addHeader("X-Appbuilder-Authorization", AppBuilderSecretKey).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            String resBody = response.body().string();
            return resBody;
        }
        catch (Exception e) {
            logger.error("\u767e\u5ea6\u5927\u6a21\u578b\u5bf9\u8bdd\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static String getNewConversationId(String AppBuilderAppID, String AppBuilderSecretKey) {
        try {
            JSONObject msgBody = new JSONObject();
            msgBody.put("app_id", (Object)AppBuilderAppID);
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)msgBody.toJSONString());
            Request request = new Request.Builder().url("https://qianfan.baidubce.com/v2/app/conversation").method("POST", body).addHeader("Content-Type", "application/json").addHeader("X-Appbuilder-Authorization", AppBuilderSecretKey).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject resBody = JSON.parseObject((String)response.body().string());
            return resBody.getString("conversation_id");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String AppBuilderAppID = "3706fadf-be2d-4374-ad55-b12468a2fa9b";
        String AppBuilderSecretKey = "3706fadf-be2d-4374-ad55-b12468a2fa9b";
        String chatContent = "\"\u9879\u76ee\u540d\u79f0\"\uff1a\"\u6cd5\u5170\u76f2\u677f\" \uff0c \"\u9879\u76ee\u7279\u5f81\u63cf\u8ff0\"\uff1a\"1.\u6750\u6599\u540d\u79f0\uff1a\u6cd5\u5170\u76f2\u677f\uff0c2.\u6750\u8d28\u89c4\u683c\uff1aDN15 S30408  RF CL150\uff0c3.\u6807\u51c6\uff1aNB/T47010II HG/T20615A\" \u8bf7\u6839\u636e\u63d0\u4f9b\u7684\u6570\u636e\u4fe1\u606f\u8bc6\u522b\u51fa\u5176\u5206\u7c7b\u548c\u5c5e\u6027\uff0c\u5c5e\u6027\u5728\u77e5\u8bc6\u5e93\u4e2d\u5339\u914d\u4e0d\u4e0a\u7684\uff0c\u4f5c\u4e3a\u6269\u5c55\u5c5e\u6027\u5217\u51fa\uff0c\u7ed3\u679c\u4ee5JSON\u683c\u5f0f\u5c55\u793a\uff0c\u4ee5\u4fbf\u53ef\u4ee5\u76f4\u63a5\u4f7f\u7528JSON.parse()\u65b9\u6cd5\u89e3\u6790\u7ed3\u679c";
        logger.info("\u8bf7\u6c42\u5f00\u59cb----");
        String re = QianfanUtils.postChatMsg(chatContent, AppBuilderAppID, AppBuilderSecretKey);
        logger.info("\u8bf7\u6c42\u7ed3\u675f\uff0c\u8fd4\u56de\u7ed3\u679c------" + re);
        JSONObject qFanContent = JSON.parseObject((String)re);
        String answer = qFanContent.getString("answer");
        logger.info("\u8bc6\u522b\u7ed3\u679c------" + answer);
        if (StringUtils.isNotBlank((CharSequence)answer)) {
            answer = answer.split("```json")[1];
            answer = answer.split("```")[0];
            logger.info("\u8bc6\u522b\u7ed3\u679c------" + answer);
        }
    }
}

