/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.vo.KnowledgeBaseVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.List;
import java.util.Random;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"knowledgeBase"})
public class KnowledgeBaseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IKnowledgeBaseService service;

    public String generateRandomString(int length) {
        String characters = "abcdefghijklmnopqrstuvwxyz";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(characters.length());
            char randomChar = characters.charAt(index);
            sb.append(randomChar);
        }
        return sb.toString();
    }

    private String generateCode(String name) {
        String code = "";
        try {
            String str;
            HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
            defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            code = str = PinyinHelper.toHanyuPinyinString((String)name, (HanyuPinyinOutputFormat)defaultFormat, (String)"");
            boolean flag = true;
            while (flag) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"code", (Object)code);
                wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                List list = this.service.list((Wrapper)wrapper);
                if (list != null && list.size() > 0) {
                    code = str + this.generateRandomString(4);
                    continue;
                }
                flag = false;
            }
        }
        catch (Exception e) {
            this.logger.info("\u751f\u6210\u7f16\u7801\u5931\u8d25:{}", (Throwable)e);
            throw new BusinessException("\u751f\u6210\u7f16\u7801\u5931\u8d25");
        }
        return code;
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<KnowledgeBaseVO> saveOrUpdate(@RequestBody KnowledgeBaseVO saveOrUpdateVO) {
        KnowledgeBaseEntity entity = (KnowledgeBaseEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KnowledgeBaseEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String code = this.generateCode(entity.getName());
            entity.setCode(code);
            this.service.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        KnowledgeBaseEntity uniqueBean = (KnowledgeBaseEntity)((Object)this.service.selectById(entity.getId()));
        uniqueBean.setName(entity.getName());
        uniqueBean.setKnowledgeType(entity.getKnowledgeType());
        uniqueBean.setIngestMaxOverlap(entity.getIngestMaxOverlap());
        uniqueBean.setRetrieveMaxResults(entity.getRetrieveMaxResults());
        uniqueBean.setRetrieveMinScore(entity.getRetrieveMinScore());
        uniqueBean.setSequence(entity.getSequence());
        uniqueBean.setRemark(entity.getRemark());
        this.service.saveOrUpdate((Object)uniqueBean, false);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<KnowledgeBaseVO> queryDetail(Long id) {
        KnowledgeBaseEntity entity = (KnowledgeBaseEntity)((Object)this.service.selectById(id));
        KnowledgeBaseVO vo = (KnowledgeBaseVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeBaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.service.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<KnowledgeBaseVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), KnowledgeBaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

