/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.KnowledgeCategoryEntity;
import com.ejianc.foundation.ai.service.IKnowledgeCategoryService;
import com.ejianc.foundation.ai.vo.KnowledgeCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"knowledgeCategory"})
public class KnowledgeCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IKnowledgeCategoryService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<KnowledgeCategoryVO> saveOrUpdate(@RequestBody KnowledgeCategoryVO saveOrUpdateVO) {
        KnowledgeCategoryEntity entity = (KnowledgeCategoryEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KnowledgeCategoryEntity.class));
        if (saveOrUpdateVO.getId() == null) {
            Long id = IdWorker.getId();
            entity.setId(id);
            if (saveOrUpdateVO.getParentId() != null) {
                KnowledgeCategoryEntity pe = (KnowledgeCategoryEntity)((Object)this.service.selectById(saveOrUpdateVO.getParentId()));
                entity.setInnerCode(pe.getInnerCode() + "|" + id);
            } else {
                entity.setInnerCode(id + "");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        KnowledgeCategoryVO vo = (KnowledgeCategoryVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeCategoryVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<KnowledgeCategoryVO> queryDetail(Long id) {
        KnowledgeCategoryEntity entity = (KnowledgeCategoryEntity)((Object)this.service.selectById(id));
        KnowledgeCategoryVO vo = (KnowledgeCategoryVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(Long id) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(id);
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public static List<KnowledgeCategoryVO> createTreeData(List<KnowledgeCategoryVO> list) {
        ArrayList<KnowledgeCategoryVO> resp = new ArrayList<KnowledgeCategoryVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, KnowledgeCategoryVO> listMap = new HashMap<String, KnowledgeCategoryVO>();
        for (KnowledgeCategoryVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            KnowledgeCategoryVO item;
            item = list.get(i);
            String parentId = item.getParentId() != null ? item.getParentId().toString() : "";
            KnowledgeCategoryVO parent = (KnowledgeCategoryVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<KnowledgeCategoryVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    ArrayList<KnowledgeCategoryVO> children = new ArrayList<KnowledgeCategoryVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            }
            if (item.getInnerCode().contains("|")) continue;
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((KnowledgeCategoryVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<KnowledgeCategoryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sequence", "asc");
        List page = this.service.queryList(param, false);
        List<KnowledgeCategoryVO> pageData = BeanMapper.mapList((Iterable)page, KnowledgeCategoryVO.class);
        pageData = KnowledgeCategoryController.createTreeData(pageData);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"/refKnowledgeCategoryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<KnowledgeCategoryVO>> refKnowledgeCategoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), KnowledgeCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

