/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.bean.AgentDialogContentEntity;
import com.ejianc.foundation.ai.bean.AgentDialogEntity;
import com.ejianc.foundation.ai.bean.AgentEntity;
import com.ejianc.foundation.ai.bean.ModelEntity;
import com.ejianc.foundation.ai.mapper.AgentMapper;
import com.ejianc.foundation.ai.service.IAgentDialogContentService;
import com.ejianc.foundation.ai.service.IAgentDialogService;
import com.ejianc.foundation.ai.service.IAgentService;
import com.ejianc.foundation.ai.service.IModelService;
import com.ejianc.foundation.ai.utils.QianfanUtils;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="agentService")
public class AgentServiceImpl
extends BaseServiceImpl<AgentMapper, AgentEntity>
implements IAgentService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IModelService modelService;
    @Autowired
    private IAgentDialogService dialogService;
    @Autowired
    private IAgentDialogContentService contentService;

    @Override
    public CommonResponse<JSONObject> chatWithAgent(String text, Long agentId, Long dialogId) {
        AgentEntity agentEntity = (AgentEntity)((Object)this.selectById(agentId));
        JSONObject res = new JSONObject();
        int sequence = 0;
        if (dialogId == null) {
            dialogId = IdWorker.getId();
            AgentDialogEntity dialogEntity = new AgentDialogEntity();
            dialogEntity.setId(dialogId);
            dialogEntity.setAgentId(agentId);
            dialogEntity.setSessionId(UUID.randomUUID().toString().replaceAll("-", ""));
            dialogEntity.setName(text.length() > 20 ? text.substring(0, 20) + "..." : text);
            dialogEntity.setTopUp(0);
            dialogEntity.setModelId(agentEntity.getModelId());
            this.dialogService.saveOrUpdate((Object)dialogEntity, false);
        } else {
            QueryParam queryParam = QueryParam.getInstance();
            queryParam.getParams().put("dialogId", new Parameter("eq", (Object)dialogId));
            queryParam.getOrderMap().put("sequence", "desc");
            List list = this.contentService.queryList(queryParam, false);
            if (ListUtil.isNotEmpty((List)list)) {
                sequence = ((AgentDialogContentEntity)((Object)list.get(0))).getSequence() + 1;
            }
        }
        String resStr = null;
        this.contentService.saveUserContent(text, dialogId, sequence);
        ++sequence;
        if (agentEntity == null) {
            resStr = "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u667a\u80fd\u4f53";
            this.contentService.saveBotContent(resStr, dialogId, sequence);
            res.put("botMsg", (Object)resStr);
            res.put("dialogId", (Object)dialogId);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)res);
        }
        if (agentEntity.getAgentState() == null || !agentEntity.getAgentState().booleanValue()) {
            resStr = "\u4f60\u5df2\u7ecf\u628a\u6211\u505c\u7528\u4e86\uff0c\u542f\u7528\u540e\u518d\u6765\u548c\u6211\u5bf9\u8bdd\u5427\u3002";
            this.contentService.saveBotContent(resStr, dialogId, sequence);
            res.put("botMsg", (Object)resStr);
            res.put("dialogId", (Object)dialogId);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)res);
        }
        ModelEntity model = (ModelEntity)((Object)this.modelService.selectById(agentEntity.getModelId()));
        if (model == null) {
            resStr = "\u4f60\u6ca1\u6709\u7ed9\u6211\u8bbe\u7f6e\u5927\u6a21\u578b\uff0c\u6211\u65e0\u6cd5\u56de\u7b54\u95ee\u9898\u54e6\uff01";
            this.contentService.saveBotContent(resStr, dialogId, sequence);
            res.put("botMsg", (Object)resStr);
            res.put("dialogId", (Object)dialogId);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)res);
        }
        if (model.getModelState() != 1) {
            resStr = "\u554a\u54e6\uff0c\u4f60\u7ed9\u6211\u8bbe\u7f6e\u7684\u5927\u6a21\u578b\u5df2\u7ecf\u88ab\u505c\u7528\u4e86\uff01";
            this.contentService.saveBotContent(resStr, dialogId, sequence);
            res.put("botMsg", (Object)resStr);
            res.put("dialogId", (Object)dialogId);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)res);
        }
        StringBuilder content = new StringBuilder();
        content.append("\u89d2\u8272\u8bbe\u5b9a\uff1a\u3010").append(agentEntity.getRoleInstruction()).append("\u3011").append("\n");
        content.append("\u8bf7\u6839\u636e\u4ee5\u4e0a\u89d2\u8272\u8bbe\u5b9a\uff0c\u56de\u7b54\u4ee5\u4e0b\u95ee\u9898\uff1a").append("\n");
        content.append("\u95ee\u9898\uff1a\u3010").append(text).append("\u3011").append("\n");
        this.logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a\n{}", (Object)content);
        if ("deepseek".equals(model.getPlatform())) {
            resStr = QianfanUtils.postChatMsgDeepSeek(content.toString(), model.getModelName());
            this.contentService.saveBotContent(resStr, dialogId, sequence);
            res.put("botMsg", (Object)resStr);
            res.put("dialogId", (Object)dialogId);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)res);
        }
        resStr = "\u554a\u54e6\uff0c\u4f60\u7ed9\u6211\u8bbe\u7f6e\u7684\u5927\u6a21\u578b\u6ca1\u6709\u5bf9\u5e94\u7684\u5b9e\u73b0\uff01";
        this.contentService.saveBotContent(resStr, dialogId, sequence);
        res.put("botMsg", (Object)resStr);
        res.put("dialogId", (Object)dialogId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)res);
    }
}

