/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeCategoryEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbedingStore;
import com.ejianc.foundation.ai.mapper.KnowledgeEmbeddingPointsMapper;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeCategoryService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingService;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.KnowledgeEmbeddingPointsVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.onnx.allminilml6v2.AllMiniLmL6V2EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="knowledgeEmbeddingPointsService")
public class KnowledgeEmbeddingPointsServiceImpl
extends BaseServiceImpl<KnowledgeEmbeddingPointsMapper, KnowledgeEmbeddingPointsEntity>
implements IKnowledgeEmbeddingPointsService {
    @Autowired
    private EjcAiEmbedingStore aiEmbedingStore;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeCategoryService knowledgeCategoryService;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;

    @Override
    public KnowledgeEmbeddingPointsVO saveData(KnowledgeEmbeddingPointsVO saveOrUpdateVO) {
        KnowledgeEmbeddingPointsEntity entity = (KnowledgeEmbeddingPointsEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KnowledgeEmbeddingPointsEntity.class));
        KnowledgeEmbeddingEntity embeddingEntity = (KnowledgeEmbeddingEntity)((Object)this.knowledgeEmbeddingService.selectById(saveOrUpdateVO.getEmbeddingId()));
        KnowledgeItemEntity itemEntity = (KnowledgeItemEntity)((Object)this.knowledgeItemService.selectById(embeddingEntity.getItemId()));
        KnowledgeCategoryEntity category = (KnowledgeCategoryEntity)((Object)this.knowledgeCategoryService.selectById(itemEntity.getCategoryId()));
        KnowledgeBaseEntity knowledgeBase = (KnowledgeBaseEntity)((Object)this.knowledgeBaseService.selectById(category.getKnowledgeBaseId()));
        String indexName = knowledgeBase.getCode();
        AllMiniLmL6V2EmbeddingModel embeddingModel = new AllMiniLmL6V2EmbeddingModel();
        EmbeddingStore<TextSegment> embeddingStore = this.aiEmbedingStore.getEmbeddingStore(indexName);
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setType(2);
        } else {
            this.aiEmbedingStore.removeById(saveOrUpdateVO.getUuid());
        }
        JSONObject json = this.documentSplitUtil.documentStoreSingle(saveOrUpdateVO.getContent(), (EmbeddingModel)embeddingModel, embeddingStore);
        Embedding embedding = (Embedding)json.get((Object)"embedding");
        String redisId = (String)json.get((Object)"redisId");
        entity.setUuid(redisId);
        entity.setContent(saveOrUpdateVO.getContent());
        entity.setVector(Arrays.toString(embedding.vector()));
        this.saveOrUpdate((Object)entity, false);
        KnowledgeEmbeddingPointsVO vo = (KnowledgeEmbeddingPointsVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeEmbeddingPointsVO.class));
        return vo;
    }

    @Override
    public void delData(KnowledgeEmbeddingPointsVO vo) {
        if (StringUtils.isNotBlank((CharSequence)vo.getUuid())) {
            this.aiEmbedingStore.removeById(vo.getUuid());
        }
        this.removeById(vo.getId());
    }
}

