/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeCategoryEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbedingStore;
import com.ejianc.foundation.ai.mapper.KnowledgeEmbeddingMapper;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeCategoryService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingService;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.KnowledgeEmbeddingVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.onnx.allminilml6v2.AllMiniLmL6V2EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="knowledgeEmbeddingService")
public class KnowledgeEmbeddingServiceImpl
extends BaseServiceImpl<KnowledgeEmbeddingMapper, KnowledgeEmbeddingEntity>
implements IKnowledgeEmbeddingService {
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;
    @Autowired
    private EjcAiEmbedingStore aiEmbedingStore;
    @Autowired
    private IKnowledgeCategoryService knowledgeCategoryService;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;

    @Override
    public KnowledgeEmbeddingVO saveData(KnowledgeEmbeddingVO saveOrUpdateVO) {
        KnowledgeEmbeddingEntity entity = (KnowledgeEmbeddingEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KnowledgeEmbeddingEntity.class));
        KnowledgeItemEntity itemEntity = (KnowledgeItemEntity)((Object)this.knowledgeItemService.selectById(saveOrUpdateVO.getItemId()));
        KnowledgeCategoryEntity category = (KnowledgeCategoryEntity)((Object)this.knowledgeCategoryService.selectById(itemEntity.getCategoryId()));
        KnowledgeBaseEntity knowledgeBase = (KnowledgeBaseEntity)((Object)this.knowledgeBaseService.selectById(category.getKnowledgeBaseId()));
        String indexName = knowledgeBase.getCode();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setType(2);
            entity.setSliceState(1);
            this.generateStore(indexName, entity);
        } else {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"embedding_id", (Object)saveOrUpdateVO.getId());
            wrapper.eq((Object)"type", (Object)1);
            List list = this.knowledgeEmbeddingPointsService.list((Wrapper)wrapper);
            if (list != null && list.size() > 0) {
                KnowledgeEmbeddingPointsEntity en = (KnowledgeEmbeddingPointsEntity)((Object)list.get(0));
                AllMiniLmL6V2EmbeddingModel embeddingModel = new AllMiniLmL6V2EmbeddingModel();
                EmbeddingStore<TextSegment> embeddingStore = this.aiEmbedingStore.getEmbeddingStore(indexName);
                this.aiEmbedingStore.removeById(en.getUuid());
                JSONObject json = this.documentSplitUtil.documentStoreSingle(saveOrUpdateVO.getContent(), (EmbeddingModel)embeddingModel, embeddingStore);
                Embedding embedding = (Embedding)json.get((Object)"embedding");
                String redisId = (String)json.get((Object)"redisId");
                entity.setUuid(redisId);
                entity.setContent(saveOrUpdateVO.getContent());
                en.setUuid(redisId);
                en.setContent(saveOrUpdateVO.getContent());
                en.setVector(Arrays.toString(embedding.vector()));
                this.knowledgeEmbeddingPointsService.saveOrUpdate((Object)en, false);
            } else {
                this.generateStore(indexName, entity);
            }
        }
        this.saveOrUpdate((Object)entity, false);
        KnowledgeEmbeddingVO vo = (KnowledgeEmbeddingVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeEmbeddingVO.class));
        return vo;
    }

    private void generateStore(String indexName, KnowledgeEmbeddingEntity entity) {
        AllMiniLmL6V2EmbeddingModel embeddingModel = new AllMiniLmL6V2EmbeddingModel();
        EmbeddingStore<TextSegment> embeddingStore = this.aiEmbedingStore.getEmbeddingStore(indexName);
        JSONObject json = this.documentSplitUtil.documentStoreSingle(entity.getContent(), (EmbeddingModel)embeddingModel, embeddingStore);
        Embedding embedding = (Embedding)json.get((Object)"embedding");
        String redisId = (String)json.get((Object)"redisId");
        entity.setId(IdWorker.getId());
        entity.setUuid(redisId);
        entity.setType(2);
        KnowledgeEmbeddingPointsEntity en = new KnowledgeEmbeddingPointsEntity();
        en.setEmbeddingId(entity.getId());
        en.setUuid(redisId);
        en.setContent(entity.getContent());
        en.setVector(Arrays.toString(embedding.vector()));
        en.setType(1);
        this.knowledgeEmbeddingPointsService.saveOrUpdate((Object)en, false);
    }

    @Override
    public void delData(Long id) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"embedding_id", (Object)id);
        List list = this.knowledgeEmbeddingPointsService.list((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            for (KnowledgeEmbeddingPointsEntity entity : list) {
                if (!StringUtils.isNotBlank((CharSequence)entity.getUuid())) continue;
                this.aiEmbedingStore.removeById(entity.getUuid());
            }
            this.knowledgeEmbeddingPointsService.remove((Wrapper)wrapper);
        }
        this.removeById(id);
    }
}

