/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeCategoryEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbedingStore;
import com.ejianc.foundation.ai.mapper.KnowledgeItemMapper;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeCategoryService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingService;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.KnowledgeItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.splitter.DocumentSplitters;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.onnx.allminilml6v2.AllMiniLmL6V2EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="knowledgeItemService")
public class KnowledgeItemServiceImpl
extends BaseServiceImpl<KnowledgeItemMapper, KnowledgeItemEntity>
implements IKnowledgeItemService {
    @Autowired
    private DocumentSplitUtil documentSplitUtil;
    @Autowired
    private EjcAiEmbedingStore aiEmbedingStore;
    @Autowired
    private IKnowledgeCategoryService knowledgeCategoryService;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;

    @Override
    public KnowledgeItemVO insert(KnowledgeItemVO saveOrUpdateVO) {
        KnowledgeCategoryEntity category = (KnowledgeCategoryEntity)((Object)this.knowledgeCategoryService.selectById(saveOrUpdateVO.getCategoryId()));
        KnowledgeBaseEntity knowledgeBase = (KnowledgeBaseEntity)((Object)this.knowledgeBaseService.selectById(category.getKnowledgeBaseId()));
        String indexName = knowledgeBase.getCode();
        KnowledgeItemEntity entity = (KnowledgeItemEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KnowledgeItemEntity.class));
        if (saveOrUpdateVO.getId() == null) {
            entity.setUploadUserId(InvocationInfoProxy.getUserid());
        }
        this.saveOrUpdate((Object)entity, false);
        Document document = this.documentSplitUtil.loadDocument(entity.getFileSuffix(), entity.getFilePath());
        DocumentSplitter documentSplitter = DocumentSplitters.recursive((int)entity.getSliceMaxLength(), (int)entity.getSliceOverlap());
        AllMiniLmL6V2EmbeddingModel embeddingModel = new AllMiniLmL6V2EmbeddingModel();
        EmbeddingStore<TextSegment> embeddingStore = this.aiEmbedingStore.getEmbeddingStore(indexName);
        JSONObject json = this.documentSplitUtil.documentSplitStore(document, documentSplitter, (EmbeddingModel)embeddingModel, embeddingStore);
        List segments = (List)json.get((Object)"segments");
        List embeddings = (List)json.get((Object)"embeddings");
        List redisIds = (List)json.get((Object)"redisIds");
        ArrayList<KnowledgeEmbeddingEntity> list = new ArrayList<KnowledgeEmbeddingEntity>();
        ArrayList<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<KnowledgeEmbeddingPointsEntity>();
        for (int i = 0; i < segments.size(); ++i) {
            TextSegment segment = (TextSegment)segments.get(i);
            Embedding embedding = (Embedding)embeddings.get(i);
            String id = (String)redisIds.get(i);
            KnowledgeEmbeddingEntity e = new KnowledgeEmbeddingEntity();
            e.setId(IdWorker.getId());
            e.setUuid(id);
            e.setItemId(entity.getId());
            e.setContent(segment.text());
            e.setSliceState(1);
            e.setType(1);
            list.add(e);
            KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
            p.setEmbeddingId(e.getId());
            p.setUuid(id);
            p.setContent(segment.text());
            p.setVector(Arrays.toString(embedding.vector()));
            p.setType(1);
            listPoints.add(p);
        }
        if (list != null && list.size() > 0) {
            this.knowledgeEmbeddingService.saveOrUpdateBatch(list, list.size(), false);
            this.knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
        }
        KnowledgeItemVO vo = (KnowledgeItemVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeItemVO.class));
        return vo;
    }

    @Override
    public KnowledgeItemVO saveData(KnowledgeItemVO saveOrUpdateVO) {
        KnowledgeItemEntity entity = (KnowledgeItemEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), KnowledgeItemEntity.class));
        if (saveOrUpdateVO.getId() == null) {
            entity.setUploadUserId(InvocationInfoProxy.getUserid());
        }
        this.saveOrUpdate((Object)entity, false);
        KnowledgeItemVO vo = (KnowledgeItemVO)((Object)BeanMapper.map((Object)((Object)entity), KnowledgeItemVO.class));
        return vo;
    }
}

