/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.config.EjcAiBeanConfig;
import com.ejianc.framework.core.exception.BusinessException;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.loader.UrlDocumentLoader;
import dev.langchain4j.data.document.parser.TextDocumentParser;
import dev.langchain4j.data.document.parser.apache.pdfbox.ApachePdfBoxDocumentParser;
import dev.langchain4j.data.document.parser.apache.poi.ApachePoiDocumentParser;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.util.Collections;
import java.util.List;
import okhttp3.MediaType;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.search.SearchResult;

@Component
public class DocumentSplitUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String[] POI_DOC_TYPES = new String[]{"doc", "docx", "ppt", "pptx", "xls", "xlsx"};
    private static final MediaType mediaType = MediaType.parse((String)"application/json");
    @Autowired
    private EjcAiBeanConfig aiBeanConfig;

    public Document loadDocument(String fileSuffix, String fileUrl) {
        Document result = null;
        if (fileSuffix.equalsIgnoreCase("txt")) {
            result = UrlDocumentLoader.load((String)fileUrl, (DocumentParser)new TextDocumentParser());
        } else if (fileSuffix.equalsIgnoreCase("pdf")) {
            result = UrlDocumentLoader.load((String)fileUrl, (DocumentParser)new ApachePdfBoxDocumentParser());
        } else if (ArrayUtils.contains((Object[])POI_DOC_TYPES, (Object)fileSuffix)) {
            result = UrlDocumentLoader.load((String)fileUrl, (DocumentParser)new ApachePoiDocumentParser());
        } else {
            throw new BusinessException("\u76ee\u524d\u4e0d\u652f\u6301" + fileSuffix + "\u6587\u4ef6\u683c\u5f0f\u89e3\u6790");
        }
        return result;
    }

    public JSONObject documentSplitStore(Document document, DocumentSplitter documentSplitter, EmbeddingModel embeddingModel, EmbeddingStore<TextSegment> embeddingStore) {
        JSONObject json = new JSONObject();
        try {
            List<Document> documents = Collections.singletonList(document);
            List segments = documentSplitter.splitAll(documents);
            List embeddings = (List)embeddingModel.embedAll(segments).content();
            List redisIds = embeddingStore.addAll(embeddings, segments);
            json.put("segments", (Object)segments);
            json.put("embeddings", (Object)embeddings);
            json.put("redisIds", (Object)redisIds);
        }
        catch (Exception e) {
            this.logger.info("\u5c06\u6587\u4ef6\u5b58\u5165\u5411\u91cf\u6570\u636e\u5e93\uff1a{}", (Throwable)e);
            throw new BusinessException("\u5c06\u6587\u4ef6\u5b58\u5165\u5411\u91cf\u6570\u636e\u5e93");
        }
        return json;
    }

    public JSONObject documentStoreSingle(String document, EmbeddingModel embeddingModel, EmbeddingStore<TextSegment> embeddingStore) {
        JSONObject json = new JSONObject();
        try {
            Embedding embedding = (Embedding)embeddingModel.embed(document).content();
            String redisId = embeddingStore.add(embedding);
            json.put("embedding", (Object)embedding);
            json.put("redisId", (Object)redisId);
        }
        catch (Exception e) {
            this.logger.info("\u5c06\u6587\u4ef6\u5b58\u5165\u5411\u91cf\u6570\u636e\u5e93\uff1a{}", (Throwable)e);
            throw new BusinessException("\u5c06\u6587\u4ef6\u5b58\u5165\u5411\u91cf\u6570\u636e\u5e93");
        }
        return json;
    }

    public static void main(String[] args) throws Exception {
        JedisPooled client = new JedisPooled("47.93.115.124", 6379, "default", "17Liancloud");
        SearchResult d = client.ftSearch("gongchengbuzerenchengben");
        long s = client.del("embedding:a84191dc-09c6-4a5f-9e33-9079e57e354c");
        System.out.println(s);
    }
}

