package com.ejianc.foundation.ai.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * AI知识库
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ai_knowledge_base")
public class KnowledgeBaseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="name")
    private String name; // 知识库名称
    @TableField(value="code")
    private String code; // 知识库编码
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="knowledge_type")
    private Integer knowledgeType; // 知识库类型： 1：文本知识库 ，2：表格知识库
    @TableField(value="ingest_max_overlap")
    private Integer ingestMaxOverlap; // 设置文档切块时重叠的最大数量（按token来计），对完整句子切割时才考虑重叠
    @TableField(value="retrieve_max_results")
    private Integer retrieveMaxResults; // 设置召回向量最大数量,默认为0,表示由系统根据模型的contentWindow自动调整
    @TableField(value="retrieve_min_score")
    private BigDecimal retrieveMinScore; // 设置向量搜索时命中所需的最低分数,为0表示使用默认
    @TableField(value="reference_count")
    private Integer referenceCount; // 引用次数
    @TableField(value="sequence")
    private Integer sequence; // 排序号

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getKnowledgeType() {
        return knowledgeType;
    }

    public void setKnowledgeType(Integer knowledgeType) {
        this.knowledgeType = knowledgeType;
    }

    public Integer getIngestMaxOverlap() {
        return ingestMaxOverlap;
    }

    public void setIngestMaxOverlap(Integer ingestMaxOverlap) {
        this.ingestMaxOverlap = ingestMaxOverlap;
    }

    public Integer getRetrieveMaxResults() {
        return retrieveMaxResults;
    }

    public void setRetrieveMaxResults(Integer retrieveMaxResults) {
        this.retrieveMaxResults = retrieveMaxResults;
    }

    public BigDecimal getRetrieveMinScore() {
        return retrieveMinScore;
    }

    public void setRetrieveMinScore(BigDecimal retrieveMinScore) {
        this.retrieveMinScore = retrieveMinScore;
    }

    public Integer getReferenceCount() {
        return referenceCount;
    }

    public void setReferenceCount(Integer referenceCount) {
        this.referenceCount = referenceCount;
    }

    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
}
