package com.ejianc.foundation.ai.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * AI知识库文件
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ai_knowledge_item")
public class KnowledgeItemEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="knowledge_base_id")
    private Long knowledgeBaseId; // 知识库ID
    @TableField(value="category_id")
    private Long categoryId; // 分类ID
    @TableField(value="file_id")
    private Long fileId; // 文件ID
    @TableField(value="file_name")
    private String fileName; // 文件名称
    @TableField(value="brief")
    private String brief; // 文档摘要
    @TableField(value="file_path")
    private String filePath; // 文件路径
    @TableField(value="file_size")
    private Long fileSize; // 文件大小
    @TableField(value="file_suffix")
    private String fileSuffix; // 文件格式
    @TableField(value="online_path")
    private String onlinePath; // 预览地址
    @TableField(value="file_state")
    private Integer fileState; // 文件状态（1：启用，0：停用）
    @TableField(value="knowledge_type")
    private Integer knowledgeType; // 文件类型,1:文本型知识库,2:表格型知识库
    @TableField(value="reference_count")
    private Integer referenceCount; // 引用次数
    @TableField(value="sequence")
    private Integer sequence; // 排序号
    @TableField(value="embedding_count")
    private Integer embeddingCount; // 向量数
    @TableField(value="embedding_status")
    private Integer embeddingStatus; // 向量化状态：向量化状态, 1:未向量化,2:正在向量化,3:已向量化,4:失败
    @TableField(value="embedding_status_change_time")
    private Date embeddingStatusChangeTime; // 向量化状态变更时间
    @TableField(value="upload_user_id")
    private Long uploadUserId; // 上传人ID
    @TableField(value="slice_strategy")
    private Integer sliceStrategy; // 切片策略,0默认切分，1自定义切片

    @TableField(value="slice_identifier")
    private String sliceIdentifier; // 标识符
    @TableField(value="slice_expression")
    private String sliceExpression; // 表达式
    @TableField(value="slice_max_length")
    private Integer sliceMaxLength; // 切片最大长度
    @TableField(value="slice_overlap")
    private Integer sliceOverlap; // 切片重叠最大字数占比

    public Long getKnowledgeBaseId() {
        return knowledgeBaseId;
    }

    public void setKnowledgeBaseId(Long knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }
    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
    public Long getFileSize() {
        return fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }
    public String getFileSuffix() {
        return fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }
    public String getOnlinePath() {
        return onlinePath;
    }

    public void setOnlinePath(String onlinePath) {
        this.onlinePath = onlinePath;
    }
    public Integer getFileState() {
        return fileState;
    }

    public void setFileState(Integer fileState) {
        this.fileState = fileState;
    }

    public Integer getKnowledgeType() {
        return knowledgeType;
    }

    public void setKnowledgeType(Integer knowledgeType) {
        this.knowledgeType = knowledgeType;
    }

    public Integer getReferenceCount() {
        return referenceCount;
    }

    public void setReferenceCount(Integer referenceCount) {
        this.referenceCount = referenceCount;
    }
    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
    public Integer getEmbeddingCount() {
        return embeddingCount;
    }

    public void setEmbeddingCount(Integer embeddingCount) {
        this.embeddingCount = embeddingCount;
    }
    public Integer getEmbeddingStatus() {
        return embeddingStatus;
    }

    public void setEmbeddingStatus(Integer embeddingStatus) {
        this.embeddingStatus = embeddingStatus;
    }
    public Date getEmbeddingStatusChangeTime() {
        return embeddingStatusChangeTime;
    }

    public void setEmbeddingStatusChangeTime(Date embeddingStatusChangeTime) {
        this.embeddingStatusChangeTime = embeddingStatusChangeTime;
    }
    public Long getUploadUserId() {
        return uploadUserId;
    }

    public void setUploadUserId(Long uploadUserId) {
        this.uploadUserId = uploadUserId;
    }

    public Integer getSliceStrategy() {
        return sliceStrategy;
    }

    public void setSliceStrategy(Integer sliceStrategy) {
        this.sliceStrategy = sliceStrategy;
    }

    public String getSliceIdentifier() {
        return sliceIdentifier;
    }

    public void setSliceIdentifier(String sliceIdentifier) {
        this.sliceIdentifier = sliceIdentifier;
    }

    public String getSliceExpression() {
        return sliceExpression;
    }

    public void setSliceExpression(String sliceExpression) {
        this.sliceExpression = sliceExpression;
    }

    public Integer getSliceMaxLength() {
        return sliceMaxLength;
    }

    public void setSliceMaxLength(Integer sliceMaxLength) {
        this.sliceMaxLength = sliceMaxLength;
    }

    public Integer getSliceOverlap() {
        return sliceOverlap;
    }

    public void setSliceOverlap(Integer sliceOverlap) {
        this.sliceOverlap = sliceOverlap;
    }
}
