package com.ejianc.foundation.ai.config;

import com.ejianc.framework.cache.CacheConfiguration;
import com.ejianc.framework.cache.redis.CacheManager;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.onnx.allminilml6v2.AllMiniLmL6V2EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.redis.RedisEmbeddingStore;
import org.springframework.beans.factory.annotation.Autowired;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPooled;
import jodd.util.ArraysUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EjcAiEmbeding {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private String redisHost;
    private Integer redisPort;
    private String redisPassword;
    private static final int DIMENSION = 1536;

    @Autowired
    private CacheConfiguration cacheConfiguration;
    private final EmbeddingModel embeddingModel = new AllMiniLmL6V2EmbeddingModel();

    public EjcAiEmbeding() {}

    public EjcAiEmbeding(String redisHost, Integer redisPort, String redisPassword) {
        this.redisHost = redisHost;
        this.redisPort = redisPort;
        this.redisPassword = redisPassword;
    }

    private final Map<String, EmbeddingStore<TextSegment>> embeddingStoreMap = new HashMap<>();

    public EmbeddingModel getEmbeddingModel() {
        return embeddingModel;
    }

    public EmbeddingStore<TextSegment> getEmbeddingStore(String indexName) {
        EmbeddingStore<TextSegment> embeddingStore = embeddingStoreMap.get(indexName);
        if(embeddingStore != null) {
            return embeddingStore;
        }
        synchronized (indexName) {
            embeddingStore = RedisEmbeddingStore.builder().host(redisHost).port(redisPort).user("default").password(redisPassword).dimension(DIMENSION).indexName(indexName).build();
            embeddingStoreMap.put(indexName, embeddingStore);
            return embeddingStore;
        }
    }
}
