package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.service.IAgentService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * AI模型表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("chat")
public class ChatController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAgentService agentService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/chatWithAgent", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> chatWithAgent(@RequestBody JSONObject param) {
        if(param == null){
            return CommonResponse.error("参数为空！");
        }
        String text = param.getString("text");
        Long agentId = param.getLong("agentId");
        Long dialogId = param.getLong("dialogId");
        return agentService.chatWithAgent(text,agentId,dialogId);
    }

}
