package com.ejianc.foundation.ai.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.ai.bean.KnowledgeCategoryEntity;
import com.ejianc.foundation.ai.service.IKnowledgeCategoryService;
import com.ejianc.foundation.ai.vo.KnowledgeCategoryVO;

/**
 * AI知识库分类表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("knowledgeCategory")
public class KnowledgeCategoryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IKnowledgeCategoryService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KnowledgeCategoryVO> saveOrUpdate(@RequestBody KnowledgeCategoryVO saveOrUpdateVO) {
    	KnowledgeCategoryEntity entity = BeanMapper.map(saveOrUpdateVO, KnowledgeCategoryEntity.class);
        if(saveOrUpdateVO.getId() == null){
            Long id = IdWorker.getId();
            entity.setId(id);
            if(saveOrUpdateVO.getParentId()!=null){
                KnowledgeCategoryEntity pe = service.selectById(saveOrUpdateVO.getParentId());
                entity.setInnerCode(pe.getInnerCode() + "|" + id);
            }else{
                entity.setInnerCode(id+"");
            }
        }else{
            entity = service.selectById(saveOrUpdateVO.getId());
            entity.setCode(saveOrUpdateVO.getCode());
            entity.setName(saveOrUpdateVO.getName());
            entity.setSequence(saveOrUpdateVO.getSequence());
        }
    	service.saveOrUpdate(entity, false);
    	KnowledgeCategoryVO vo = BeanMapper.map(entity, KnowledgeCategoryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KnowledgeCategoryVO> queryDetail(Long id) {
    	KnowledgeCategoryEntity entity = service.selectById(id);
    	KnowledgeCategoryVO vo = BeanMapper.map(entity, KnowledgeCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> delete(Long id) {
        List<Long> ids  = new ArrayList<>();
        ids.add(id);
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    public static List<KnowledgeCategoryVO> createTreeData(List<KnowledgeCategoryVO> list) {
        List<KnowledgeCategoryVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, KnowledgeCategoryVO> listMap = new HashMap<>();
        for(KnowledgeCategoryVO item:list) {
            listMap.put(item.getId().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            KnowledgeCategoryVO item = list.get(i);
            String parentId = (item.getParentId() != null) ? item.getParentId().toString():"";
            KnowledgeCategoryVO parent = listMap.get(parentId);
            if(parent != null) {
                List<KnowledgeCategoryVO> child = (List<KnowledgeCategoryVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<KnowledgeCategoryVO> children = new ArrayList<KnowledgeCategoryVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            }
            if(!item.getInnerCode().contains("|")){
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<KnowledgeCategoryVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sequence", QueryParam.ASC);
        List<KnowledgeCategoryEntity> page = service.queryList(param,false);
        List<KnowledgeCategoryVO> pageData = BeanMapper.mapList(page, KnowledgeCategoryVO.class);
        pageData = createTreeData(pageData);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refKnowledgeCategoryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<KnowledgeCategoryVO>> refKnowledgeCategoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<KnowledgeCategoryEntity> page = service.queryPage(param,false);
        IPage<KnowledgeCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), KnowledgeCategoryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
