package com.ejianc.foundation.ai.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.KnowledgeItemTableIndexEntity;
import com.ejianc.foundation.ai.service.IKnowledgeItemTableIndexService;
import com.ejianc.foundation.ai.vo.KnowledgeItemTableIndexVO;
import com.ejianc.foundation.ai.vo.KnowledgeItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

/**
 * AI知识库表格索引
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("knowledgeItemTableIndex")
public class KnowledgeItemTableIndexController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IKnowledgeItemTableIndexService service;
    @Autowired
    private EnvironmentTools environmentTools;

    @Value("${refer.base-host:null}")
    private String baseHost;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KnowledgeItemTableIndexVO> saveOrUpdate(@RequestBody KnowledgeItemTableIndexVO saveOrUpdateVO) {
        KnowledgeItemTableIndexEntity entity = BeanMapper.map(saveOrUpdateVO, KnowledgeItemTableIndexEntity.class);
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("修改成功");
    }

    /**
     * @Description saveOrUpdate 配置表格数据
     */
    @RequestMapping(value = "/configTableIndex", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> configTableIndex(@RequestBody KnowledgeItemTableIndexVO vo) {
        service.configTableIndex(vo);
        return CommonResponse.success("配置成功！");
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KnowledgeItemTableIndexVO> queryDetail(Long id) {
        KnowledgeItemTableIndexEntity entity = service.selectById(id);
        KnowledgeItemTableIndexVO vo = BeanMapper.map(entity, KnowledgeItemTableIndexVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryByItemId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KnowledgeItemTableIndexVO> queryByItemId(Long itemId) {
        QueryWrapper<KnowledgeItemTableIndexEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("item_id", itemId);
        List<KnowledgeItemTableIndexEntity> list = service.list(wrapper);
        KnowledgeItemTableIndexVO vo = null;
        if(list!=null && list.size()>0){
            KnowledgeItemTableIndexEntity indexEntity = list.get(0);
            vo = BeanMapper.map(indexEntity, KnowledgeItemTableIndexVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        service.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KnowledgeItemTableIndexVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getOrderMap().put("createTime", QueryParam.DESC);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<KnowledgeItemTableIndexEntity> page = service.queryPage(param,false);
        IPage<KnowledgeItemTableIndexVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), KnowledgeItemTableIndexVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
