package com.ejianc.foundation.ai.controller.api.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.foundation.ai.utils.QianfanAppBuilderUtil;
import com.ejianc.framework.core.response.CommonResponse;
import okhttp3.*;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;

/**
 * @description: 材料小票AI识别
 * @author songlx
 * @date 2025/2/20
 * @version 1.0
 */
@RestController
@RequestMapping("/api/receiptAi1")
public class ReceiptAiApi1 {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder().readTimeout(180, TimeUnit.SECONDS).build();

    @Value("${ejc.ai.train.AppBuilderAppID:88796cca-a864-4617-ba72-850e333352ea}")
    private String AppBuilderAppID;
    @Value("${ejc.ai.train.AppBuilderSecretKey:Bearer bce-v3/ALTAK-l39HjVaikGeUyvhYR3fJ9/acf6cc3782f9b3d9fc5dd58be0d8dd244655e50c}")
    private String AppBuilderSecretKey;


    /**
     * @description: 小票识别、识别发货小票与业务单据绑定
     * 上传图片业务类型固定值：receiptAi + 各自单据类型
     *
     * @param imageUrl https://test.17elian.com/ejc-file-web/attachment/filePreview?fileId=947488209787445271
     * @param imageName 1.jpg
     * @return {@link CommonResponse< String>}
     * @author songlx
     * @date: 2025/2/20
     */
    @RequestMapping(value = "identify", method = RequestMethod.GET)
    public CommonResponse<String> identify(String imageUrl, String imageName) {
        String conversationId = QianfanAppBuilderUtil.getNewConversationId(AppBuilderAppID, AppBuilderSecretKey);
        try {
            String fileId = QianfanAppBuilderUtil.uploadLocalFile(AppBuilderAppID, AppBuilderSecretKey, conversationId, imageUrl, imageName);
            JSONObject para = new JSONObject();
            para.put("app_id", AppBuilderAppID);

            /*#你是一个问题推荐助手，需要根据<题目>、<解析>以及老师和学生的<答疑内容>过程上下文，推测学生的下一个问题会是什么

            1. 需要仔细分析<题目>、<解析>以及老师和学生的<答疑内容>，理解学生的当前思路，推测学生的理解盲区
            2. 一次输出三条学生可能问的推测问题，每个推测问题字数控制在10个字以内
            3. 推测问题需要符合学生的思路，需要符合当前题目背景*/
            /**
             StringBuilder question = new StringBuilder();
             question.append("你是一个收料小票识别助手，需要根据图片识别出物料信息以及结合知识库名称为【物料档案250219】推测具体物料入库数据，最终结果以JSON数组返回");
             question.append("1. 需要识别图片提取出多条物料名称、规格型号、单位、数量、单价、金额，并形成JSON数组");
             question.append("2. 用JSON数组中的每条物料名称、规格型号、单位在知识库（物料档案250219）中推测出各自的物料ID合并进当前数据");
             question.append("3. 把结果以完整的JSON数组返回");
             */
            para.put("query", "从图片中提取出多条物料名称、规格型号、单位、数量、单价、金额，并以JSON数组输出");
            para.put("conversation_id", conversationId);
            para.put("stream", false);
            para.put("file_ids", Arrays.asList(fileId));
            logger.info("================参数=============================");
            logger.info(JSONObject.toJSONString(para, SerializerFeature.PrettyFormat));
            logger.info("================================================");

            MediaType mediaType = MediaType.parse("application/json");
            RequestBody body = RequestBody.create(mediaType, para.toJSONString());
            Request request = new Request.Builder()
                    .url(Constant.ChatUrl)
                    .method("POST", body)
                    .addHeader("Content-Type", "application/json")
                    .addHeader("X-Appbuilder-Authorization", AppBuilderSecretKey)
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject qFanContent = JSON.parseObject(response.body().string());
            String answer = qFanContent.getString("answer");
            if (StringUtils.isNotBlank(answer)) {
                if (answer.contains("```json")) {
                    answer = answer.split("```json")[1];
                    answer = answer.split("```")[0];
                    JSONArray objects = JSONArray.parseArray(answer);
                    logger.info("=================结果===========================");
                    for (Object object : objects) {
                        logger.info(JSONObject.toJSONString(object, SerializerFeature.PrettyFormat));
                    }
                    logger.info("================================================");
                    return CommonResponse.success("查询数据成功！", objects.toJSONString());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return CommonResponse.success("查询数据成功！", null);
    }

    @RequestMapping(value = "identifyMaterial", method = RequestMethod.GET)
    public CommonResponse<String> identifyMaterial() {
        String conversationId = QianfanAppBuilderUtil.getNewConversationId(AppBuilderAppID, AppBuilderSecretKey);
        try {
            //String fileId = QianfanAppBuilderUtil.uploadLocalFile(AppBuilderAppID, AppBuilderSecretKey, conversationId, imageUrl, imageName);
            JSONObject para = new JSONObject();
            para.put("app_id", AppBuilderAppID);

            para.put("query", "在知识库文档中，根据物料名称：卡板加气砖19600*200*190、规格型号：19600*200*190、计量单位：块，匹配查询出多条物料信息，物料信息结信息封装成JSON数组返回");
            para.put("conversation_id", conversationId);
            para.put("stream", false);
            //para.put("file_ids", Arrays.asList("79656d77-8868-4853-967e-26a70e2eb9d1")); // 79656d77-8868-4853-967e-26a70e2eb9d1
            logger.info("================参数=============================");
            logger.info(JSONObject.toJSONString(para, SerializerFeature.PrettyFormat));
            logger.info("================================================");

            MediaType mediaType = MediaType.parse("application/json");
            RequestBody body = RequestBody.create(mediaType, para.toJSONString());
            Request request = new Request.Builder()
                    .url(Constant.ChatUrl)
                    .method("POST", body)
                    .addHeader("Content-Type", "application/json")
                    .addHeader("X-Appbuilder-Authorization", AppBuilderSecretKey)
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject qFanContent = JSON.parseObject(response.body().string());
            String answer = qFanContent.getString("answer");
            if (StringUtils.isNotBlank(answer)) {
                if (answer.contains("```json")) {
                    answer = answer.split("```json")[1];
                    answer = answer.split("```")[0];
                    JSONArray objects = JSONArray.parseArray(answer);
                    logger.info("=================结果===========================");
                    for (Object object : objects) {
                        logger.info(JSONObject.toJSONString(object, SerializerFeature.PrettyFormat));
                    }
                    logger.info("================================================");
                    return CommonResponse.success("查询数据成功！", objects.toJSONString());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return CommonResponse.success("查询数据成功！", null);
    }


}



