package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.bean.*;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.service.*;
import com.ejianc.foundation.ai.utils.ModelConst;
import com.ejianc.foundation.ai.utils.QianfanUtils;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.ollama.OllamaStreamingChatModel;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import dev.langchain4j.web.search.WebSearchEngine;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.ai.mapper.AgentMapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * AI智能体表
 * 
 * @author generator
 * 
 */
@Service("agentService")
public class AgentServiceImpl extends BaseServiceImpl<AgentMapper, AgentEntity> implements IAgentService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IModelService modelService;
    @Autowired
    private IKnowledgeMessageHistoryService KnowledgeMessageHistoryService;
    @Autowired
    private IKnowledgeMessageService knowledgeMessageService;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;

    private void saveKnowledgeMessage(Long knowledgeId, Long dialogId, String resStr) {
        KnowledgeMessageEntity answerMessageEntity = new KnowledgeMessageEntity();
        answerMessageEntity.setId(IdWorker.getId());
        answerMessageEntity.setParentId(knowledgeId);
        answerMessageEntity.setContent(resStr);
        answerMessageEntity.setUserId(InvocationInfoProxy.getUserid());
        answerMessageEntity.setMessageHistoryId(dialogId);
        knowledgeMessageService.saveOrUpdate(answerMessageEntity,false);
    }
    @Override
    public CommonResponse<JSONObject> chatWithAgent(String text, Long agentId, Long dialogId) {
        AgentEntity agentEntity = this.selectById(agentId);
        JSONObject res = new JSONObject();
        int sequence = 0;
        Long userId = InvocationInfoProxy.getUserid();
        if(dialogId == null){
            /** 新建对话 */
            dialogId = IdWorker.getId();
            KnowledgeMessageHistoryEntity historyEntity = new KnowledgeMessageHistoryEntity();
            historyEntity.setId(dialogId);
            historyEntity.setAgentId(agentId);
            historyEntity.setUserId(userId);
            historyEntity.setKnowledgeSessionId(UUID.randomUUID().toString().replaceAll("-", ""));
            historyEntity.setTopFlag(0);
            historyEntity.setTitle(text);
            KnowledgeMessageHistoryService.saveOrUpdate(historyEntity,false);
        }
        Long knowledgeMessageId = IdWorker.getId();
        String resStr = "";
        /** 保存用户对话 */
        if(agentEntity == null){
            resStr = "找不到对应的智能体";
            saveKnowledgeMessage(knowledgeMessageId, dialogId, resStr);
            res.put("botMsg",resStr);
            res.put("dialogId",dialogId);
            return CommonResponse.success("查询成功！", res);
        }
        if(agentEntity.getAgentState()==0){
            resStr = "当前访问的智能体已被停用了！";
            saveKnowledgeMessage(knowledgeMessageId, dialogId, resStr);
            res.put("botMsg",resStr);
            res.put("dialogId",dialogId);
            return CommonResponse.success("查询成功！", res);
        }
        ModelEntity model = modelService.selectById(agentEntity.getModelId());
        if(model == null){
            resStr = "当前智能体没有设置大模型，无法回答问题！";
            saveKnowledgeMessage(knowledgeMessageId, dialogId, resStr);
            res.put("botMsg",resStr);
            res.put("dialogId",dialogId);
            return CommonResponse.success("查询成功！", res);
        }
        if(model.getModelState()!=1){
            resStr = "当前智能体引用的大模型已经被停用了！";
            saveKnowledgeMessage(knowledgeMessageId, dialogId, resStr);
            res.put("botMsg",resStr);
            res.put("dialogId",dialogId);
            return CommonResponse.success("查询成功！", res);
        }
        StringBuilder contextSbf = new StringBuilder();
        String knowledgeIds = agentEntity.getKnowledgeIds();
        if(StringUtils.isNotBlank(knowledgeIds)){
            String[] knowledgeIdArr = knowledgeIds.split(",");
            for (String knowledgeId : knowledgeIdArr) {
                KnowledgeBaseEntity knowledgeBaseEntity = knowledgeBaseService.selectById(knowledgeId);

                Embedding queryEmbedding = ejcAiEmbeding.getEmbeddingModel().embed(text).content();
                EmbeddingSearchRequest embeddingSearchRequest = EmbeddingSearchRequest.builder().queryEmbedding(queryEmbedding).minScore(agentEntity.getMatchScore().doubleValue()).maxResults(agentEntity.getCallBackNum()).build();
                EmbeddingSearchResult<TextSegment> embeddedEmbeddingSearchResult = ejcAiEmbeding.getEmbeddingStore(knowledgeBaseEntity.getCode()).search(embeddingSearchRequest);
                List<EmbeddingMatch<TextSegment>> embeddingMatcheList = embeddedEmbeddingSearchResult.matches();
                EmbeddingMatch<TextSegment> embeddingMatch = embeddingMatcheList.get(0);
                TextSegment textSegment = embeddingMatch.embedded();

                if(StringUtils.isNotBlank(textSegment.text())) {
                    contextSbf.append(textSegment.text()).append(";");
                }
            }
        }
        PromptTemplate promptTemplate = PromptTemplate.from("{{template}}\n" +
                ", 基于如下信息进行回答:\n" +
                "{{context}}\n" +
                "提问:\n" +
                "{{question}}");
        Map<String, Object> variables = new HashMap<>();
        variables.put("template", agentEntity.getRoleInstruction());
        variables.put("context", contextSbf + "");
        variables.put("question", text);
        Prompt prompt = promptTemplate.apply(variables);

        if(1 == agentEntity.getStrictFlag() && StringUtils.isBlank(contextSbf + "")) {
            resStr = "当前知识库没有您提问的知识！";
            saveKnowledgeMessage(knowledgeMessageId, dialogId, resStr);

            res.put("botMsg",resStr);
            res.put("dialogId",dialogId);
            return CommonResponse.success("查询成功！", res);
        }

        if(1 == model.getPlatform()) { //本地大模型
            OllamaChatModel ollamaChatModel = OllamaChatModel.builder()
                    .baseUrl(model.getBaseUrl())
                    .modelName(model.getModelName())
                    .build();
            UserMessage userMessage = prompt.toUserMessage();
            Response<AiMessage> aiMessageResp = ollamaChatModel.generate(userMessage);
            resStr = aiMessageResp.content().text();
            saveKnowledgeMessage(knowledgeMessageId, dialogId, resStr);

            res.put("botMsg",resStr);
            res.put("dialogId",dialogId);
            return CommonResponse.success("查询成功！", res);
        }else if(2 == model.getPlatform()) { //千帆大模型
            String appConfig = model.getAppConfig();
            try{
                JSONObject appConfigJson = JSONObject.parseObject(appConfig);
                String appId = appConfigJson.getString("appId");
                String appSecret = appConfigJson.getString("appSecret");

                resStr = QianfanUtils.postChatMsg(prompt.text(), appId, appSecret);
                saveKnowledgeMessage(knowledgeMessageId, dialogId, resStr);

                res.put("botMsg",resStr);
                res.put("dialogId",dialogId);
                return CommonResponse.success("查询成功！", res);
            }catch(Exception e) {
                resStr = "千帆大模型配置信息有误，例子: {\"appId\":\"\",\"appSecret\":\"\"}！";
                saveKnowledgeMessage(knowledgeMessageId, dialogId, resStr);
                res.put("botMsg",resStr);
                res.put("dialogId",dialogId);
                return CommonResponse.success("查询成功！", res);
            }
        }
        resStr = "该智能体设置的大模型没有对应的实现！";
        saveKnowledgeMessage(knowledgeMessageId, dialogId, resStr);
        res.put("botMsg",resStr);
        res.put("dialogId",dialogId);
        return CommonResponse.success("查询成功！", res);
    }
}
