package com.ejianc.foundation.ai.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.ai.mapper.KnowledgeBaseMapper;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;

/**
 * AI知识库
 * 
 * @author generator
 * 
 */
@Service("knowledgeBaseService")
public class KnowledgeBaseServiceImpl extends BaseServiceImpl<KnowledgeBaseMapper, KnowledgeBaseEntity> implements IKnowledgeBaseService{

    @Autowired
    private KnowledgeBaseMapper knowledgeBaseMapper;

    @Override
    public KnowledgeBaseEntity queryBaseDataByItemId(Long embeddingId){
        return knowledgeBaseMapper.queryBaseDataByItemId(embeddingId);
    }

    @Override
    public KnowledgeBaseEntity queryBaseDataByEmbeddingId(Long embeddingId){
        return knowledgeBaseMapper.queryBaseDataByEmbeddingId(embeddingId);
    }

    @Override
    public KnowledgeBaseEntity queryBaseDataByPointsId(Long embeddingId) {
        return knowledgeBaseMapper.queryBaseDataByPointsId(embeddingId);
    }

    @Override
    public KnowledgeBaseEntity queryBaseDataByTableIndexId(Long embeddingId) {
        return knowledgeBaseMapper.queryBaseDataByTableIndexId(embeddingId);
    }

}
