package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingEntity;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.bean.KnowledgeItemEntity;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeEmbeddingPointsMapper;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingService;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.KnowledgeEmbeddingPointsVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;

/**
 * 知识库切片知识点表
 * 
 * @author generator
 * 
 */
@Service("knowledgeEmbeddingPointsService")
public class KnowledgeEmbeddingPointsServiceImpl extends BaseServiceImpl<KnowledgeEmbeddingPointsMapper, KnowledgeEmbeddingPointsEntity> implements IKnowledgeEmbeddingPointsService{

    @Autowired
    private KnowledgeEmbeddingPointsMapper knowledgeEmbeddingPointsMapper;
    @Autowired
    private EjcAiEmbeding aiEmbedingStore;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;
    @Override
    public KnowledgeEmbeddingPointsVO saveData(KnowledgeEmbeddingPointsVO saveOrUpdateVO) {
        KnowledgeEmbeddingPointsEntity entity = BeanMapper.map(saveOrUpdateVO, KnowledgeEmbeddingPointsEntity.class);
        KnowledgeEmbeddingEntity embeddingEntity = knowledgeEmbeddingService.selectById(saveOrUpdateVO.getEmbeddingId());
        if(embeddingEntity.getSliceState()==0){
            throw new BusinessException("切片已停用，不支持修改知识点信息，请先启用切片");
        }
        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(embeddingEntity.getItemId());
        String indexName = knowledgeBase.getCode();

        EmbeddingModel embeddingModel = aiEmbedingStore.getEmbeddingModel();
        //// 删除向量数据库中的信息
        EmbeddingStore<TextSegment> embeddingStore = aiEmbedingStore.getEmbeddingStore(indexName);
        if(entity.getId() == null || entity.getId() == 0){
            entity.setType(2);
            entity.setInitContent(saveOrUpdateVO.getContent());
        }else{
            embeddingStore.remove(saveOrUpdateVO.getUuid());
            if(entity.getType()==1){
                entity.setType(3);
            }
        }
        //执行文件切分
        JSONObject json = documentSplitUtil.documentStoreSingle(saveOrUpdateVO.getContent(), embeddingModel, embeddingStore);

        Embedding embedding = (Embedding) json.get("embedding");
        String redisId = (String) json.get("redisId");
        entity.setUuid("embedding:"+redisId);
        entity.setContent(saveOrUpdateVO.getContent());
        entity.setVector(Arrays.toString(embedding.vector()));

        this.saveOrUpdate(entity, false);

        KnowledgeItemEntity itemEntity = knowledgeItemService.selectById(embeddingEntity.getItemId());
        Integer embeddingCount = this.countEmbeddingByItemId(embeddingEntity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);

        KnowledgeEmbeddingPointsVO vo = BeanMapper.map(entity, KnowledgeEmbeddingPointsVO.class);
        return vo;
    }

    @Override
    public void delData(KnowledgeEmbeddingPointsVO vo) {
        if(StringUtils.isNotBlank(vo.getUuid())){
            KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByEmbeddingId(vo.getEmbeddingId());
            String indexName = knowledgeBase.getCode();
            EmbeddingStore<TextSegment> embeddingStore = aiEmbedingStore.getEmbeddingStore(indexName);
            embeddingStore.remove(vo.getUuid());
        }
        this.removeById(vo.getId());

        KnowledgeEmbeddingEntity embeddingEntity = knowledgeEmbeddingService.selectById(vo.getEmbeddingId());
        KnowledgeItemEntity itemEntity = knowledgeItemService.selectById(embeddingEntity.getItemId());
        Integer embeddingCount = this.countEmbeddingByItemId(embeddingEntity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);

    }

    @Override
    public Integer countEmbeddingByItemId(Long itemId){
        return knowledgeEmbeddingPointsMapper.countEmbeddingByItemId(itemId);
    }
}
