package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.*;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeEmbeddingMapper;
import com.ejianc.foundation.ai.service.*;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.KnowledgeEmbeddingVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 知识切片表（向量）
 * 
 * @author generator
 * 
 */
@Service("knowledgeEmbeddingService")
public class KnowledgeEmbeddingServiceImpl extends BaseServiceImpl<KnowledgeEmbeddingMapper, KnowledgeEmbeddingEntity> implements IKnowledgeEmbeddingService{

    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;
    @Autowired
    private EjcAiEmbeding aiEmbedingStore;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;
    @Autowired
    private IKnowledgeItemTableIndexService knowledgeItemTableIndexService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;

    @Override
    public KnowledgeEmbeddingVO saveData(KnowledgeEmbeddingVO saveOrUpdateVO) {
        KnowledgeEmbeddingEntity entity = BeanMapper.map(saveOrUpdateVO, KnowledgeEmbeddingEntity.class);

        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(saveOrUpdateVO.getItemId());
        String indexName = knowledgeBase.getCode();

        if(entity.getId() == null || entity.getId() == 0){
            //新增，新增向量+切片
            entity.setType(2);
            entity.setSliceState(1);
            this.generateStore(indexName, entity);
        }else{
            if(entity.getType()==1){
                entity.setType(3);
            }
            //获取自动切片的知识点，并且修改一下向量数据信息
            QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("embedding_id", saveOrUpdateVO.getId());
            wrapper.in("type", 1,3);
            List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
            if(list!=null && list.size()>0){
                KnowledgeEmbeddingPointsEntity en = list.get(0);
                EmbeddingModel embeddingModel = aiEmbedingStore.getEmbeddingModel();
                //// 删除向量数据库中的信息
                EmbeddingStore<TextSegment> embeddingStore = aiEmbedingStore.getEmbeddingStore(indexName);
                embeddingStore.remove(en.getUuid());

                //执行文件切分
                JSONObject json = documentSplitUtil.documentStoreSingle(saveOrUpdateVO.getContent(), embeddingModel, embeddingStore);

                Embedding embedding = (Embedding) json.get("embedding");
                String redisId = (String) json.get("redisId");

                entity.setUuid("embedding:"+redisId);
                entity.setContent(saveOrUpdateVO.getContent());

                en.setUuid("embedding:"+redisId);
                en.setContent(saveOrUpdateVO.getContent());
                en.setVector(Arrays.toString(embedding.vector()));

                knowledgeEmbeddingPointsService.saveOrUpdate(en, false);
            }else{
                this.generateStore(indexName, entity);
            }
        }
        this.saveOrUpdate(entity, false);

        KnowledgeItemEntity itemEntity = knowledgeItemService.selectById(entity.getItemId());
        Integer embeddingCount = knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);

        KnowledgeEmbeddingVO vo = BeanMapper.map(entity, KnowledgeEmbeddingVO.class);
        return vo;
    }

    private void generateStore(String indexName, KnowledgeEmbeddingEntity entity){
        EmbeddingModel embeddingModel = aiEmbedingStore.getEmbeddingModel();
        //// 删除向量数据库中的信息
        EmbeddingStore<TextSegment> embeddingStore = aiEmbedingStore.getEmbeddingStore(indexName);

        //执行文件切分
        JSONObject json = documentSplitUtil.documentStoreSingle(entity.getContent(), embeddingModel, embeddingStore);

        Embedding embedding = (Embedding) json.get("embedding");
        String redisId = (String) json.get("redisId");

        entity.setId(IdWorker.getId());
        entity.setUuid("embedding:"+redisId);
        if(entity.getType()==null){
            entity.setType(2);
        }

        KnowledgeEmbeddingPointsEntity en = new KnowledgeEmbeddingPointsEntity();
        en.setEmbeddingId(entity.getId());
        en.setUuid("embedding:"+redisId);
        en.setContent(entity.getContent());
        en.setInitContent(entity.getContent());
        en.setVector(Arrays.toString(embedding.vector()));
        en.setType(1);
        knowledgeEmbeddingPointsService.saveOrUpdate(en, false);
    }

    @Override
    public void delData(Long id) {
        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByEmbeddingId(id);
        String indexName = knowledgeBase.getCode();
        //查询知识点并删除redis中的信息
        QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("embedding_id", id);
        List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
        if(list!=null && list.size()>0){
            List<String> rids = new ArrayList<>();
            list.forEach(item -> {
                rids.add(item.getUuid());
            });
            //// 删除向量数据库中的信息
            EmbeddingStore<TextSegment> embeddingStore = aiEmbedingStore.getEmbeddingStore(indexName);
            embeddingStore.removeAll(rids);
            knowledgeEmbeddingPointsService.remove(wrapper);
        }
        this.removeById(id);

        KnowledgeEmbeddingEntity entity = this.selectById(id);
        KnowledgeItemEntity itemEntity = knowledgeItemService.selectById(entity.getItemId());
        Integer embeddingCount = knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);
    }

    @Override
    public KnowledgeEmbeddingVO saveTableData(KnowledgeEmbeddingVO saveOrUpdateVO) {
        if(saveOrUpdateVO.getType()!=null && (saveOrUpdateVO.getType()==1 || saveOrUpdateVO.getType()==3)){
            //自动生成修改后状态修改未
            saveOrUpdateVO.setType(3);
        }else{
            saveOrUpdateVO.setType(2);
        }
        String tableContent = saveOrUpdateVO.getTableContent();

        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(saveOrUpdateVO.getItemId());
        String indexName = knowledgeBase.getCode();

        QueryWrapper<KnowledgeItemTableIndexEntity> tableWrapper = new QueryWrapper<>();
        tableWrapper.eq("item_id", saveOrUpdateVO.getItemId());
        List<KnowledgeItemTableIndexEntity> indexList = knowledgeItemTableIndexService.list(tableWrapper);
        String indexs = null;
        String titles = null;
        if(indexList!=null && indexList.size()>0){
            indexs = indexList.get(0).getIndexs();
            titles = indexList.get(0).getTitles();
        }else{
            throw new BusinessException("为获取到该文档的索引信息，请先配置索引");
        }
        if(StringUtils.isBlank(indexs)){
            throw new BusinessException("为获取到该文档的索引信息，请先配置索引");
        }
        if(StringUtils.isBlank(titles)){
            throw new BusinessException("为获取到该文档的表头信息，请先确认上传文件的格式是否正确");
        }
        //表格型知识库
        String[] titlesArray = titles.split(",");
        String[] indexsArray = indexs.split(",");
        JSONObject ob = JSONObject.parseObject(tableContent);
        String o = "";
        for(int j=0; j<titlesArray.length; j++){
            o += (titlesArray[j] + ": " +ob.get(titlesArray[j]) + " ");
        }
        if(saveOrUpdateVO.getId()==null){
            saveOrUpdateVO.setSliceState(1);
            saveOrUpdateVO.setContent(o);
            saveOrUpdateVO.setInitContent(tableContent);
        }

        KnowledgeEmbeddingEntity entity = BeanMapper.map(saveOrUpdateVO, KnowledgeEmbeddingEntity.class);
        this.saveOrUpdate(entity, false);
        KnowledgeEmbeddingVO vo = BeanMapper.map(entity, KnowledgeEmbeddingVO.class);
        QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("embedding_id", saveOrUpdateVO.getId());
        wrapper.in("type", 1,3);
        List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
        EmbeddingStore<TextSegment> embeddingStore = aiEmbedingStore.getEmbeddingStore(indexName);
        if(list!=null && list.size()>0){
            List<String> delredisIds = new ArrayList<>();
            list.forEach(e -> {
                delredisIds.add(e.getUuid());
            });
            embeddingStore.removeAll(delredisIds);
            knowledgeEmbeddingPointsService.remove(wrapper);
        }

        List allRedisIds = new ArrayList();
        try {
            List<TextSegment> documents = new ArrayList<>();
            List<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<>();


            TextSegment s = TextSegment.from(o);
            documents.add(s);

            for(int j=0; j<indexsArray.length; j++){
                String index = indexsArray[j];
                documents.add(TextSegment.from(index+": "+ob.getString(index)));
            }
            EmbeddingModel embeddingModel = aiEmbedingStore.getEmbeddingModel();

            //执行文件切分
            JSONObject json = documentSplitUtil.documentStoreList(documents, embeddingModel, embeddingStore);

            List embeddings = (List) json.get("embeddings");
            allRedisIds = (List) json.get("redisIds");
            for(int j=0; j<documents.size(); j++){
                TextSegment segment = documents.get(j);
                Embedding embedding = (Embedding) embeddings.get(j);
                String id = (String) allRedisIds.get(j);

                KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                p.setEmbeddingId(entity.getId());
                p.setUuid("embedding:"+id);
                p.setContent(segment.text());
                p.setInitContent(segment.text());
                p.setVector(Arrays.toString(embedding.vector()));
                p.setType(1);
                listPoints.add(p);
            }

            if(listPoints!=null && listPoints.size()>0){
                knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
            }
        }catch (Exception e){
            //删除生成的向量数据库信息
            embeddingStore.removeAll(allRedisIds);
            throw new BusinessException("生成向量数据库信息失败");
        }

        KnowledgeItemEntity itemEntity = knowledgeItemService.selectById(entity.getItemId());
        Integer embeddingCount = knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);
        return vo;
    }

    @Override
    public KnowledgeEmbeddingVO enableData(KnowledgeEmbeddingVO data) {
        KnowledgeEmbeddingEntity entity = this.selectById(data.getId());
        entity.setSliceState(1);
        this.saveOrUpdate(entity, false);
        //保存向量信息
        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(data.getItemId());
        String indexName = knowledgeBase.getCode();
        QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("embedding_id", data.getId());
        List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
        if(list!=null && list.size()>0){
            EmbeddingStore<TextSegment> embeddingStore = aiEmbedingStore.getEmbeddingStore(indexName);
            EmbeddingModel embeddingModel = aiEmbedingStore.getEmbeddingModel();
            for(KnowledgeEmbeddingPointsEntity pEntity : list){
                JSONObject json = documentSplitUtil.documentStoreSingle(pEntity.getContent(), embeddingModel, embeddingStore);
                Embedding embedding = (Embedding) json.get("embedding");
                String redisId = (String) json.get("redisId");
                pEntity.setUuid("embedding:"+redisId);
                pEntity.setVector(Arrays.toString(embedding.vector()));
            }
            if(list!=null && list.size()>0){
                knowledgeEmbeddingPointsService.saveOrUpdateBatch(list, list.size(), false);
            }
        }

        KnowledgeItemEntity itemEntity = knowledgeItemService.selectById(entity.getItemId());
        Integer embeddingCount = knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);

        KnowledgeEmbeddingVO vo = BeanMapper.map(entity, KnowledgeEmbeddingVO.class);
        return vo;
    }

    @Override
    public KnowledgeEmbeddingVO disableData(KnowledgeEmbeddingVO data) {
        KnowledgeEmbeddingEntity entity = this.selectById(data);
        entity.setSliceState(0);
        this.saveOrUpdate(entity, false);
        //保存向量信息
        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(data.getItemId());
        String indexName = knowledgeBase.getCode();
        QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("embedding_id", data.getId());
        List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
        if(list!=null && list.size()>0){
            EmbeddingStore<TextSegment> embeddingStore = aiEmbedingStore.getEmbeddingStore(indexName);
            List<String> delredisIds = new ArrayList<>();
            list.forEach(e -> {
                delredisIds.add(e.getUuid());
            });
            embeddingStore.removeAll(delredisIds);
        }

        KnowledgeItemEntity itemEntity = knowledgeItemService.selectById(entity.getItemId());
        Integer embeddingCount = knowledgeEmbeddingPointsService.countEmbeddingByItemId(entity.getItemId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);
        KnowledgeEmbeddingVO vo = BeanMapper.map(entity, KnowledgeEmbeddingVO.class);
        return vo;
    }
}
