package com.ejianc.foundation.ai.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.controller.api.material.Constant;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import okhttp3.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

import java.util.concurrent.TimeUnit;

/**
 * 作者 mrsir
 * 日期 2024/5/17
 * 包路径 com.ejianc.support.webpush.largeModel.qianfan
 */
public class QianfanUtils {

    private static final Logger logger = org.slf4j.LoggerFactory.getLogger(QianfanUtils.class);

    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder()
            .connectTimeout(10, TimeUnit.MINUTES)
            .readTimeout(10, TimeUnit.MINUTES)
            .writeTimeout(10, TimeUnit.MINUTES)
            .build();
    private static final MediaType mediaType = MediaType.parse("application/json");

    /**
     * 调用千帆大模型appbuilder
     * */
    public static String postChatMsg(String content ,String AppBuilderAppID,String AppBuilderSecretKey) {
        try {
            String conversationId = getNewConversationId(AppBuilderAppID, AppBuilderSecretKey);
            JSONObject msgBody = new JSONObject();
//            msgBody.put("app_id", Constant.AppBuilderAppID);
            msgBody.put("app_id", AppBuilderAppID);
            msgBody.put("query", content);
            msgBody.put("stream", false);
            msgBody.put("conversation_id", conversationId);

            RequestBody body = RequestBody.create(mediaType, msgBody.toJSONString());
            Request request = new Request.Builder()
                    .url(Constant.ChatUrl)
                    .method("POST", body)
                    .addHeader("Content-Type", Constant.ContentType)
//                    .addHeader("X-Appbuilder-Authorization", Constant.AppBuilderSecretKey)
                    .addHeader("X-Appbuilder-Authorization", AppBuilderSecretKey)
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            String resBody = response.body().string();
            logger.info("请求内容:{},请求返回：{}", content, resBody);
            return resBody;
        } catch (Exception e) {
            logger.error("百度大模型对话出错：{}", e.getMessage());
            e.printStackTrace();
        }
        return null;
    }
    /**
     * 调用千帆大模型appbuilder，获取会话id
     * */
    private static String getNewConversationId(String AppBuilderAppID,String AppBuilderSecretKey) {
        try {
            JSONObject msgBody = new JSONObject();
//            msgBody.put("app_id", Constant.AppBuilderAppID);
            msgBody.put("app_id", AppBuilderAppID);
            RequestBody body = RequestBody.create(mediaType, msgBody.toJSONString());
            Request request = new Request.Builder()
                    .url(Constant.CreateConversationUrl)
                    .method("POST", body)
                    .addHeader("Content-Type", "application/json")
//                    .addHeader("X-Appbuilder-Authorization", Constant.AppBuilderSecretKey)
                    .addHeader("X-Appbuilder-Authorization", AppBuilderSecretKey)
                    .build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            JSONObject resBody = JSON.parseObject(response.body().string());
            return resBody.getString("conversation_id");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) throws Exception{
        String AppBuilderAppID = Constant.AppBuilderAppID;
        String AppBuilderSecretKey = Constant.AppBuilderAppID;
//        String res = getNewConversationId(AppBuilderAppID,AppBuilderSecretKey);
//        System.out.println("获取会话id------"+res);
        String chatContent = "\"项目名称\"：\"法兰盲板\" ， \"项目特征描述\"：\"1.材料名称：法兰盲板，2.材质规格：DN15 S30408  RF CL150，3.标准：NB/T47010II HG/T20615A\" 请根据提供的数据信息识别出其分类和属性，属性在知识库中匹配不上的，作为扩展属性列出，结果以JSON格式展示，以便可以直接使用JSON.parse()方法解析结果";
        logger.info("请求开始----");
        String re = postChatMsg(chatContent,AppBuilderAppID,AppBuilderSecretKey);
        logger.info("请求结束，返回结果------"+re);
        JSONObject qFanContent = JSON.parseObject(re);
        String answer = qFanContent.getString("answer");
        logger.info("识别结果------"+answer);
        if(StringUtils.isNotBlank(answer)){
            answer= answer.split("```json")[1];
            answer= answer.split("```")[0];
            logger.info("识别结果------"+answer);
        }

       /* String documentId = "e871c83f-faf4-49fb-bcdb-faa12982d55d";
        // 知识库ID
        String knowledgeBaseId = "909cf7cc-0ec8-49c9-8918-9f81affacd53";
        // Appbuilder Token
        String secretKey = Constant.AppBuilderSecretKey;
        Knowledgebase knowledgebase = new Knowledgebase(knowledgeBaseId, secretKey);
        // 创建切片
        String chunkId = knowledgebase.createChunk(documentId, "test2025年2月18日10:07:23");
        System.out.println(chunkId);*/
    }
}
