package com.ejianc.foundation.ai.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * AI知识库
 *
 * @author generator
 */
public class KnowledgeBaseVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String name; // 知识库名称
    private String code; // 知识库编码
    private String remark; // 备注
    private Integer knowledgeType;
    private String knowledgeTypeName; // 知识库类型名称
    private Integer ingestMaxOverlap; // 设置文档切块时重叠的最大数量（按token来计），对完整句子切割时才考虑重叠
    private Integer retrieveMaxResults; // 设置召回向量最大数量,默认为0,表示由系统根据模型的contentWindow自动调整
    private BigDecimal retrieveMinScore; // 设置向量搜索时命中所需的最低分数,为0表示使用默认
    private Integer referenceCount; // 引用次数
    private Integer sequence; // 排序号

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getKnowledgeType() {
        return knowledgeType;
    }

    public void setKnowledgeType(Integer knowledgeType) {
        this.knowledgeType = knowledgeType;
    }

    public String getKnowledgeTypeName() {
        return knowledgeTypeName;
    }

    public void setKnowledgeTypeName(String knowledgeTypeName) {
        this.knowledgeTypeName = knowledgeTypeName;
    }

    public Integer getIngestMaxOverlap() {
        return ingestMaxOverlap;
    }

    public void setIngestMaxOverlap(Integer ingestMaxOverlap) {
        this.ingestMaxOverlap = ingestMaxOverlap;
    }

    public Integer getRetrieveMaxResults() {
        return retrieveMaxResults;
    }

    public void setRetrieveMaxResults(Integer retrieveMaxResults) {
        this.retrieveMaxResults = retrieveMaxResults;
    }

    public BigDecimal getRetrieveMinScore() {
        return retrieveMinScore;
    }

    public void setRetrieveMinScore(BigDecimal retrieveMinScore) {
        this.retrieveMinScore = retrieveMinScore;
    }

    public Integer getReferenceCount() {
        return referenceCount;
    }

    public void setReferenceCount(Integer referenceCount) {
        this.referenceCount = referenceCount;
    }

    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

}
