package com.ejianc.framework.auth.shiro;

import com.ejianc.framework.auth.token.ITokenProcessor;
import com.ejianc.framework.auth.token.TokenParameter;
import org.apache.shiro.authc.AuthenticationToken;

import java.util.Map;

public class StatelessToken implements AuthenticationToken {

	private static final long serialVersionUID = -7316737568510866049L;
	
	private String username;
	// 预留参数集合，校验更复杂的权限
    private Map<String, ?> params;
    private String clientDigest;
    ITokenProcessor tokenProcessor;
    TokenParameter tp;
    public StatelessToken(String username, ITokenProcessor tokenProcessor, TokenParameter tp ,  Map<String, ?> params, String clientDigest) {
        this.username = username;
        this.params = params;
        this.tp = tp;
        this.tokenProcessor = tokenProcessor;
        this.clientDigest = clientDigest;
    }

    public TokenParameter getTp() {
		return tp;
	}

	public void setTp(TokenParameter tp) {
		this.tp = tp;
	}

	public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public  Map<String, ?> getParams() {
        return params;
    }

    public void setParams( Map<String, ?> params) {
        this.params = params;
    }

    public String getClientDigest() {
        return clientDigest;
    }

    public void setClientDigest(String clientDigest) {
        this.clientDigest = clientDigest;
    }

    @Override
    public Object getPrincipal() {
       return username;
    }

    @Override
    public Object getCredentials() {
        return clientDigest;
    }

	public ITokenProcessor getTokenProcessor() {
		return tokenProcessor;
	}

	public void setTokenProcessor(ITokenProcessor tokenProcessor) {
		this.tokenProcessor = tokenProcessor;
	}

 
    
}
