package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.KnowledgeEmbeddingPointsEntity;
import com.ejianc.foundation.ai.service.IKnowledgeEmbeddingPointsService;
import com.ejianc.foundation.ai.vo.KnowledgeEmbeddingPointsVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 知识库切片知识点表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("knowledgeEmbeddingPoints")
public class KnowledgeEmbeddingPointsController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IKnowledgeEmbeddingPointsService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KnowledgeEmbeddingPointsVO> saveOrUpdate(@RequestBody KnowledgeEmbeddingPointsVO saveOrUpdateVO) {
        KnowledgeEmbeddingPointsVO vo = service.saveData(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KnowledgeEmbeddingPointsVO> queryDetail(Long id) {
    	KnowledgeEmbeddingPointsEntity entity = service.selectById(id);
    	KnowledgeEmbeddingPointsVO vo = BeanMapper.map(entity, KnowledgeEmbeddingPointsVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody KnowledgeEmbeddingPointsVO vo) {
        service.delData(vo);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description restoreData 还原
     */
    @RequestMapping(value = "/restoreData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KnowledgeEmbeddingPointsVO> restoreData(@RequestBody KnowledgeEmbeddingPointsVO data) {
        KnowledgeEmbeddingPointsVO vo = service.restoreData(data);
        return CommonResponse.success("还原数据成功！",vo);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<KnowledgeEmbeddingPointsVO>> queryList(Long id) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("content");
        param.getOrderMap().put("sequence", QueryParam.DESC);
        param.getOrderMap().put("createTime", QueryParam.DESC);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("embeddingId", new Parameter(QueryParam.EQ, id));

        List<KnowledgeEmbeddingPointsEntity> list = service.queryList(param,false);
        List<KnowledgeEmbeddingPointsVO> vos = null;
        if(list!=null && list.size()>0){
            vos = BeanMapper.mapList(list, KnowledgeEmbeddingPointsVO.class);
        }
        return CommonResponse.success("查询列表数据成功！",vos);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<KnowledgeEmbeddingPointsEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("KnowledgeEmbeddingPoints-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refKnowledgeEmbeddingPointsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<KnowledgeEmbeddingPointsVO>> refKnowledgeEmbeddingPointsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<KnowledgeEmbeddingPointsEntity> page = service.queryPage(param,false);
        IPage<KnowledgeEmbeddingPointsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), KnowledgeEmbeddingPointsVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
