package com.ejianc.foundation.ai.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.api.param.ChunkParam;
import com.ejianc.foundation.ai.api.param.UpdateChunkParam;
import com.ejianc.foundation.ai.api.result.ChunkResult;
import com.ejianc.foundation.ai.bean.*;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeEmbeddingMapper;
import com.ejianc.foundation.ai.service.*;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RestController
@RequestMapping("/api/knowledge")
public class KnowledgeApi {
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;
    @Autowired
    private IKnowledgeItemTableIndexService knowledgeItemTableIndexService;
    @Autowired
    private KnowledgeEmbeddingMapper embeddingMapper;

    /**
     * 新增切片
     *
     * @return
     */
    @RequestMapping(value = "/createChunk", method = RequestMethod.POST)
    public CommonResponse<ChunkResult> createChunk(@RequestBody ChunkParam chunkParam) {
        List<String> chunkContent = chunkParam.getChunkContent(); //分片内容
        QueryWrapper<KnowledgeBaseEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("code", chunkParam.getKnowledgeBaseCode());
        KnowledgeBaseEntity knowledgeBaseEntity = knowledgeBaseService.getOne(queryWrapper);
        if(knowledgeBaseEntity == null) {
            throw new BusinessException("知识库编码不存在");
        }
        QueryWrapper<KnowledgeItemEntity> itemWrapper = new QueryWrapper<>();
        itemWrapper.eq("code", chunkParam.getKnowledgeItemCode());
        KnowledgeItemEntity itemEntity = knowledgeItemService.getOne(itemWrapper);
        if(itemEntity == null) {
            throw new BusinessException("文件编号不存在");
        }
        String indexName = knowledgeBaseEntity.getCode();

        KnowledgeEmbeddingEntity entity = new KnowledgeEmbeddingEntity();
        //新增，新增向量+切片
        entity.setType(2);
        entity.setSliceState(1);
        Integer maxSequence = embeddingMapper.selectMaxSequence(itemEntity.getId());
        maxSequence++;

        EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
        //// 删除向量数据库中的信息
        EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
        List<JSONObject> chunkInfo = new ArrayList<>();
        for(String content : chunkContent){
            if(1 == knowledgeBaseEntity.getKnowledgeType()) { //文本知识库
                entity.setInitContent(content);
                entity.setSequence(maxSequence);
                //执行文件切分
                JSONObject json = documentSplitUtil.documentStoreSingle(entity.getContent(), embeddingModel, embeddingStore);
                Embedding embedding = (Embedding) json.get("embedding");
                String redisId = (String) json.get("redisId");
                entity.setId(IdWorker.getId());
                entity.setUuid(indexName+":"+redisId);
                KnowledgeEmbeddingPointsEntity en = new KnowledgeEmbeddingPointsEntity();
                en.setEmbeddingId(entity.getId());
                en.setUuid(indexName+":"+redisId);
                en.setContent(entity.getContent());
                en.setInitContent(entity.getContent());
                en.setVector(Arrays.toString(embedding.vector()));
                en.setSequence(1);
                en.setType(1);
                knowledgeEmbeddingPointsService.saveOrUpdate(en, false);
            }else if(2 == knowledgeBaseEntity.getKnowledgeType()) { // 表格知识库
                entity.setInitContent(content);
                entity.setSequence(maxSequence);
                QueryWrapper<KnowledgeItemTableIndexEntity> tableWrapper = new QueryWrapper<>();
                tableWrapper.eq("item_id", itemEntity.getId());
                List<KnowledgeItemTableIndexEntity> indexList = knowledgeItemTableIndexService.list(tableWrapper);
                String indexs = null;
                String titles = null;
                if(indexList!=null && indexList.size()>0){
                    indexs = indexList.get(0).getIndexs();
                    titles = indexList.get(0).getTitles();
                }else{
                    throw new BusinessException("为获取到该文档的索引信息，请先配置索引");
                }
                if(org.apache.commons.lang3.StringUtils.isBlank(indexs)){
                    throw new BusinessException("为获取到该文档的索引信息，请先配置索引");
                }
                if(org.apache.commons.lang3.StringUtils.isBlank(titles)){
                    throw new BusinessException("为获取到该文档的表头信息，请先确认上传文件的格式是否正确");
                }
                //表格型知识库
                String[] titlesArray = titles.split(",");
                String[] indexsArray = indexs.split(",");
                JSONObject ob = JSONObject.parseObject(content);
                String o = "";
                for(int j=0; j<titlesArray.length; j++){
                    o += (titlesArray[j] + ": " +ob.get(titlesArray[j]) + " ");
                }
                entity.setSliceState(1);
                entity.setContent(o);
                entity.setInitContent(content);
                knowledgeEmbeddingService.saveOrUpdate(entity, false);

                List allRedisIds = new ArrayList();
                try {
                    List<TextSegment> documents = new ArrayList<>();
                    List<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<>();
                    TextSegment s = TextSegment.from(o);
                    documents.add(s);
                    for(int j=0; j<indexsArray.length; j++){
                        String index = indexsArray[j];
                        documents.add(TextSegment.from(index+": "+ob.getString(index)));
                    }
                    //执行文件切分
                    JSONObject json = documentSplitUtil.documentStoreList(documents, embeddingModel, embeddingStore);
                    List embeddings = (List) json.get("embeddings");
                    allRedisIds = (List) json.get("redisIds");
                    for(int j=0; j<documents.size(); j++){
                        TextSegment segment = documents.get(j);
                        Embedding embedding = (Embedding) embeddings.get(j);
                        String id = (String) allRedisIds.get(j);

                        KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                        p.setEmbeddingId(entity.getId());
                        p.setUuid(indexName+":"+id);
                        p.setContent(segment.text());
                        p.setInitContent(segment.text());
                        p.setVector(Arrays.toString(embedding.vector()));
                        p.setType(1);
                        p.setSequence(documents.size()-j);
                        listPoints.add(p);
                    }

                    if(listPoints!=null && listPoints.size()>0){
                        knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                    }
                }catch (Exception e){
                    //删除生成的向量数据库信息
                    embeddingStore.removeAll(allRedisIds);
                    throw new BusinessException("生成向量数据库信息失败");
                }
            }
            JSONObject re = new JSONObject();
            re.put("id", entity.getId());
            re.put("content", content);
            chunkInfo.add(re);
        }
        Integer embeddingCount = knowledgeEmbeddingPointsService.countEmbeddingByItemId(itemEntity.getId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);

        ChunkResult result = new ChunkResult();
        result.setChunkInfo(chunkInfo);
        return CommonResponse.success(result);
    }

    /**
     * 修改切片
     *
     * @return
     */
    @RequestMapping(value = "/updateChunk", method = RequestMethod.POST)
    public CommonResponse<ChunkResult> updateChunk(@RequestBody UpdateChunkParam updateChunkParam) {
        String content = updateChunkParam.getChunkContent();
        if(StringUtils.isBlank(content)){
            throw new BusinessException("内容不能为空");
        }
        KnowledgeEmbeddingEntity embeddingEntity = knowledgeEmbeddingService.selectById(updateChunkParam.getChunkId());
        if(embeddingEntity == null) {
            throw new BusinessException("知识切片不存在");
        }
        KnowledgeBaseEntity knowledgeBaseEntity = knowledgeBaseService.queryBaseDataByEmbeddingId(embeddingEntity.getId());
        String indexName = knowledgeBaseEntity.getCode();

        EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
        //// 删除向量数据库中的信息
        EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
        if(1 == knowledgeBaseEntity.getKnowledgeType()) { //文本知识库
            embeddingEntity.setInitContent(content);
            embeddingEntity.setContent(content);
            embeddingEntity.setType(3);
            //获取自动切片的知识点，并且修改一下向量数据信息
            QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("embedding_id", embeddingEntity.getId());
            wrapper.in("type", 1,3);
            List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
            if(list!=null && list.size()>0){
                KnowledgeEmbeddingPointsEntity en = list.get(0);
                embeddingStore.remove(en.getUuid());
                //执行文件切分
                JSONObject json = documentSplitUtil.documentStoreSingle(content, embeddingModel, embeddingStore);
                Embedding embedding = (Embedding) json.get("embedding");
                String redisId = (String) json.get("redisId");
                embeddingEntity.setUuid(indexName+":"+redisId);
                en.setUuid(indexName+":"+redisId);
                en.setContent(content);
                en.setVector(Arrays.toString(embedding.vector()));
                knowledgeEmbeddingPointsService.saveOrUpdate(en, false);
            }else{
                //执行文件切分
                JSONObject json = documentSplitUtil.documentStoreSingle(content, embeddingModel, embeddingStore);
                Embedding embedding = (Embedding) json.get("embedding");
                String redisId = (String) json.get("redisId");
                embeddingEntity.setUuid(indexName+":"+redisId);
                KnowledgeEmbeddingPointsEntity en = new KnowledgeEmbeddingPointsEntity();
                en.setEmbeddingId(embeddingEntity.getId());
                en.setUuid(indexName+":"+redisId);
                en.setContent(embeddingEntity.getContent());
                en.setInitContent(embeddingEntity.getContent());
                en.setVector(Arrays.toString(embedding.vector()));
                en.setSequence(1);
                en.setType(1);
                knowledgeEmbeddingPointsService.saveOrUpdate(en, false);
            }
            knowledgeEmbeddingService.saveOrUpdate(embeddingEntity, false);
        }else if(2 == knowledgeBaseEntity.getKnowledgeType()) { // 表格知识库
            embeddingEntity.setInitContent(content);
            QueryWrapper<KnowledgeItemTableIndexEntity> tableWrapper = new QueryWrapper<>();
            tableWrapper.eq("item_id", embeddingEntity.getItemId());
            List<KnowledgeItemTableIndexEntity> indexList = knowledgeItemTableIndexService.list(tableWrapper);
            String indexs = null;
            String titles = null;
            if(indexList!=null && indexList.size()>0){
                indexs = indexList.get(0).getIndexs();
                titles = indexList.get(0).getTitles();
            }else{
                throw new BusinessException("为获取到该文档的索引信息，请先配置索引");
            }
            if(org.apache.commons.lang3.StringUtils.isBlank(indexs)){
                throw new BusinessException("为获取到该文档的索引信息，请先配置索引");
            }
            if(org.apache.commons.lang3.StringUtils.isBlank(titles)){
                throw new BusinessException("为获取到该文档的表头信息，请先确认上传文件的格式是否正确");
            }

            QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("embedding_id", embeddingEntity.getId());
            wrapper.in("type", 1,3);
            List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
            if(list!=null && list.size()>0){
                List<String> delredisIds = new ArrayList<>();
                list.forEach(e -> {
                    delredisIds.add(e.getUuid());
                });
                embeddingStore.removeAll(delredisIds);
                knowledgeEmbeddingPointsService.remove(wrapper);
            }

            //表格型知识库
            String[] titlesArray = titles.split(",");
            String[] indexsArray = indexs.split(",");
            JSONObject ob = JSONObject.parseObject(content);
            String o = "";
            for(int j=0; j<titlesArray.length; j++){
                o += (titlesArray[j] + ": " +ob.get(titlesArray[j]) + " ");
            }
            embeddingEntity.setSliceState(1);
            embeddingEntity.setContent(o);
            embeddingEntity.setInitContent(content);
            knowledgeEmbeddingService.saveOrUpdate(embeddingEntity, false);

            List allRedisIds = new ArrayList();
            try {
                List<TextSegment> documents = new ArrayList<>();
                List<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<>();
                TextSegment s = TextSegment.from(o);
                documents.add(s);
                for(int j=0; j<indexsArray.length; j++){
                    String index = indexsArray[j];
                    documents.add(TextSegment.from(index+": "+ob.getString(index)));
                }
                //执行文件切分
                JSONObject json = documentSplitUtil.documentStoreList(documents, embeddingModel, embeddingStore);
                List embeddings = (List) json.get("embeddings");
                allRedisIds = (List) json.get("redisIds");
                for(int j=0; j<documents.size(); j++){
                    TextSegment segment = documents.get(j);
                    Embedding embedding = (Embedding) embeddings.get(j);
                    String id = (String) allRedisIds.get(j);

                    KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                    p.setEmbeddingId(embeddingEntity.getId());
                    p.setUuid(indexName+":"+id);
                    p.setContent(segment.text());
                    p.setInitContent(segment.text());
                    p.setVector(Arrays.toString(embedding.vector()));
                    p.setType(1);
                    p.setSequence(documents.size()-j);
                    listPoints.add(p);
                }

                if(listPoints!=null && listPoints.size()>0){
                    knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                }
            }catch (Exception e){
                //删除生成的向量数据库信息
                embeddingStore.removeAll(allRedisIds);
                throw new BusinessException("生成向量数据库信息失败");
            }
        }

        ChunkResult result = new ChunkResult();
        List<JSONObject> chunkInfo = new ArrayList<>();
        JSONObject re = new JSONObject();
        re.put("id", updateChunkParam.getChunkId());
        re.put("content", content);
        chunkInfo.add(re);
        result.setChunkInfo(chunkInfo);
        return CommonResponse.success(result);
    }

    /**
     * 删除切片
     *
     * @return
     */
    @RequestMapping(value = "/deleteChunk", method = RequestMethod.POST)
    public CommonResponse<String> deleteChunk(@RequestBody Long chunkId) {
        knowledgeEmbeddingService.delData(chunkId);
        return CommonResponse.success("删除成功！");
    }

}
