package com.ejianc.foundation.ai.controller.api.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.utils.QianfanUtils;
import com.ejianc.foundation.ai.utils.ThreadPoolUtils;
import com.ejianc.foundation.ai.vo.material.*;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

@RestController
@RequestMapping
public class MaterialAiApi {
    private static final Logger logger = org.slf4j.LoggerFactory.getLogger(QianfanUtils.class);
    @Value("${ejc.ai.train.driver:com.mysql.jdbc.Driver}")
    private String driver;
    @Value("${ejc.ai.train.jdbcaddr:47.93.115.124")
    private String jdbcaddr;
    @Value("${ejc.ai.train.jdbcport:30236")
    private String jdbcport;
    @Value("${ejc.ai.train.username:root")
    private String username;
    @Value("${ejc.ai.train.username:y7rkeucv87no5j9")
    private String password;
    @Value("${ejc.ai.material.AppBuilderAppID:e5fcc66c-a174-4efe-9b21-bda373cc8816")
    private static String AppBuilderAppID;
    @Value("${ejc.ai.material.AppBuilderSecretKey:Bearer bce-v3/ALTAK-2M4n5pMZ8iRjJiaD7Ww5N/86fae65df7bef687132a4a0606bfe98e0b1e0747")
    private static String AppBuilderSecretKey;
    @RequestMapping(value = "/ai/material/recognize", method = RequestMethod.POST)
    CommonResponse<List<AiMaterialVO>> aiMaterialRecognize(@RequestBody List<AiMaterialParam> aiMaterialParams) {
        if(ListUtil.isEmpty(aiMaterialParams)) {
            return CommonResponse.error("参数为空!");
        }
        logger.info("请求数量："+aiMaterialParams.size());
        List<AiMaterialVO> resList = new ArrayList<>();
        List<Future<String>> futureList = new ArrayList<>();
        ThreadPoolUtils threadPoolUtils = ThreadPoolUtils.getInstance();
        Map<String,Future<String>> futureMap = new HashMap<>();
        for (AiMaterialParam param : aiMaterialParams) {
            Future<String> future = threadPoolUtils.runTask(() -> {
                StringBuilder content = new StringBuilder();
                content.append("\"项目描述\":\"").append(param.getItemName()).append("\",");
                content.append("\"项目特征描述\":\"").append(param.getItemDesc()).append("\";\n");
                content.append("请根据提供的数据信息识别出其分类和属性，属性在知识库中匹配不上的，作为扩展属性列出，结果以JSON格式给出，以便可以直接使用JSON.parse()方法解析结果，不要附加其他分析性语句。");
                return QianfanUtils.postChatMsg(content.toString(),AppBuilderAppID,AppBuilderSecretKey);
            });
            futureList.add(future);
            futureMap.put(param.getId(),future);
        }
        for (String key: futureMap.keySet()) {
            Future<String>  future = futureMap.get(key);
            try {
                String result = future.get();
                JSONObject qFanContent = JSON.parseObject(result);
                String answer = qFanContent.getString("answer");
                logger.info("请求 id={},返回answer={}",key,answer);
                if(StringUtils.isNotBlank(answer)){
                    if(answer.contains("```json")){
                        answer= answer.split("```json")[1];
                        answer= answer.split("```")[0];
                        JSONObject jsonObject = JSON.parseObject(answer);
                        AiMaterialVO aiMaterialVO = new AiMaterialVO();
                        aiMaterialVO.setId(key);
                        Category category  = new Category();
                        category.setCategoryId(jsonObject.getJSONObject("分类信息").getString("分类ID"));
                        category.setCategoryName(jsonObject.getJSONObject("分类信息").getString("分类名称"));
                        aiMaterialVO.setCategory(category);
                        if(jsonObject.getJSONArray("匹配属性")!=null){
                            List<MatchProperty> matchProperties = new ArrayList<>();
                            for(Object obj:jsonObject.getJSONArray("匹配属性")) {
                                JSONObject mp = (JSONObject) obj;
                                MatchProperty matchProperty = new MatchProperty();
                                matchProperty.setPropertyId(mp.getString("属性ID"));
                                matchProperty.setPropertyName(mp.getString("属性名称"));
                                matchProperty.setPropertyValueId(mp.getString("属性值ID"));
                                matchProperty.setPropertyValue(mp.getString("属性值"));
                                matchProperties.add(matchProperty);
                            }
                            aiMaterialVO.setMatchProperties(matchProperties);
                        }
                        if(jsonObject.getJSONArray("扩展属性")!=null){
                            List<ExtProperty> extProperties = new ArrayList<>();
                            for(Object obj:jsonObject.getJSONArray("扩展属性")) {
                                JSONObject ep = (JSONObject) obj;
                                ExtProperty extProperty = new ExtProperty();
                                extProperty.setPropertyKey(ep.getString("属性名称"));
                                extProperty.setPropertyValue(ep.getString("属性值"));
                                extProperties.add(extProperty);
                            }
                            aiMaterialVO.setExtProperties(extProperties);
                        }
                        resList.add(aiMaterialVO);
                    }
                }
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            } catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        logger.info("请求成功，返回数量：{}，请求数量：{}",resList.size(),aiMaterialParams.size());
        return CommonResponse.success(resList);
    }

    @RequestMapping(value = "/ai/material/train", method = RequestMethod.POST)
    CommonResponse<String> putMaterial2AiTrain(@RequestBody List<AiMaterialTrainVO> aiMaterialTrainVos) {
        if(aiMaterialTrainVos !=null && aiMaterialTrainVos.size() > 0) {
            for(AiMaterialTrainVO aiMaterialTrainVO:aiMaterialTrainVos) {
                if(aiMaterialTrainVO.getCategoryId() == null
                 || StringUtils.isBlank(aiMaterialTrainVO.getCategoryName())
                 || aiMaterialTrainVO.getPropertyId() == null
                 || StringUtils.isBlank(aiMaterialTrainVO.getPropertyName())) {
                    continue;
                }
                String insertSql = "insert into ejc_ai_material(id,categoryid,categoryname,propertyid,propertyname) " +
                        " values("+ IdWorker.getId() +",'"+aiMaterialTrainVO.getCategoryId()+"','"+aiMaterialTrainVO.getCategoryName()+"'" +
                        " ,'"+aiMaterialTrainVO.getPropertyId()+"','"+aiMaterialTrainVO.getPropertyName()+"')";
                String jdbcurl = "jdbc:mysql://"+jdbcaddr+":"+jdbcport+"/ejc-ai?useUnicode=true&characterEncoding=utf-8&autoReconnect=true&failOverReadOnly=false&useSSL=false&allowMultiQueries=true";
//                JdbcParam jdbcParam = new JdbcParam(driver, jdbcurl, username, password, insertSql);
//                JdbcDataProvider.getInstance().executeInsertSql(jdbcParam);
            }
        }
        return CommonResponse.success("执行成功!");
    }

}
