package com.ejianc.foundation.ai.controller.api.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.foundation.ai.service.ReceiptAiService;
import com.ejianc.foundation.ai.utils.QianfanAppBuilderUtil;
import com.ejianc.foundation.ai.vo.receipt.AiReceiptResultVO;
import com.ejianc.foundation.ai.vo.receipt.AiReceiptVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @description: 材料小票AI识别
 * @author songlx
 * @date 2025/2/20
 * @version 1.0
 */
@RestController
@RequestMapping("/api/receiptAi/")
public class ReceiptAiApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${ejc.ai.receipt.appBuilderAppID:88796cca-a864-4617-ba72-850e333352ea}")
    private String APP_ID;
    @Value("${ejc.ai.receipt.appBuilderSecretKey:Bearer bce-v3/ALTAK-l39HjVaikGeUyvhYR3fJ9/acf6cc3782f9b3d9fc5dd58be0d8dd244655e50c}")
    private String SECRET_KEY;
    @Value("${ejc.ai.receipt.knowledgeBaseId:99feac29-1056-4c1b-9580-ddc1af599487}")
    private String KNOWLEDGE_BASE_ID;

    @Autowired
    private ReceiptAiService receiptAiService;


    /**
     * @description: 小票识别、识别发货小票与业务单据绑定
     * 上传图片业务类型固定值：receiptAi + 各自单据类型
     *
     * @param imageUrl https://test.17elian.com/ejc-file-web/attachment/filePreview?fileId=949326675194175575
     * @param imageName 1.jpg
     * @param reIdentify 是否重新识别，同一个fileId可再次覆盖识别
     * @return {@link AiReceiptResultVO}
     * @author songlx
     * @date: 2025/2/20
     */
    @RequestMapping(value = "identify", method = RequestMethod.GET)
    public AiReceiptResultVO identify(@RequestParam String imageUrl, @RequestParam String imageName,
                                      @RequestParam(required = false, defaultValue = "false") Boolean reIdentify) {
        String fileId = imageUrl.split("fileId=")[1];
        AiReceiptResultVO result = receiptAiService.getResultFromCache(fileId);
        if (result != null && !reIdentify) {
            logger.info("获取历史结果：{}", JSONObject.toJSONString(result, SerializerFeature.PrettyFormat));
            return result;
        }
        AiReceiptResultVO resultVO = new AiReceiptResultVO();
        resultVO.setFileId(fileId);
        resultVO.setImageUrl(imageUrl);
        resultVO.setImageName(imageName);
        receiptAiService.saveResultToCache(resultVO);
        try {
            List<AiReceiptVO> resList = new ArrayList<>();
            String conversationId = QianfanAppBuilderUtil.getNewConversationId(APP_ID, SECRET_KEY);
            String confileId = QianfanAppBuilderUtil.uploadLocalFile(APP_ID, SECRET_KEY, conversationId, imageUrl, imageName);
            JSONObject para = new JSONObject();
            para.put("app_id", APP_ID);

            para.put("query", "从图片中提取出多条物料名称、规格型号、单位、数量、单价、金额，结果以JSONArray数组格式给出，未识别到返回空数据，以便可以直接使用JSONArray.parseArray()方法解析结果，不要附加其他分析性语句。");
            para.put("conversation_id", conversationId);
            para.put("stream", false);
            para.put("file_ids", Arrays.asList(confileId));
            logger.info("================参数=============================");
            logger.info(JSONObject.toJSONString(para, SerializerFeature.PrettyFormat));
            logger.info("================================================");

            JSONObject qFanContent = JSON.parseObject(QianfanAppBuilderUtil.postChatMsg(para, APP_ID, SECRET_KEY));
            String answer = qFanContent.getString("answer");
            if (StringUtils.isNotBlank(answer)) {

                if (answer.contains("```json")) {
                    answer = answer.split("```json")[1];
                    answer = answer.split("```")[0];
                    List<JSONObject> jsonObjects = JSONArray.parseArray(answer, JSONObject.class);
                    logger.info("=================图片识别结果===========================");
                    for (JSONObject obj : jsonObjects) {
                        //物料名称、规格型号、单位、数量、单价、金额
                        AiReceiptVO aiReceiptVO = new AiReceiptVO();
                        aiReceiptVO.setName(obj.getString("物料名称"));
                        aiReceiptVO.setSpec(obj.getString("规格型号"));
                        aiReceiptVO.setUnitName(obj.getString("单位"));
                        aiReceiptVO.setNum(toBigDecimal(obj.get("数量")));
                        aiReceiptVO.setPrice(toBigDecimal(obj.get("单价")));
                        aiReceiptVO.setMoney(toBigDecimal(obj.get("金额")));
                        if (StringUtils.isNotBlank(aiReceiptVO.getName())) {
                            resList.add(aiReceiptVO);
                        }
                    }
                    resultVO.setReceiptVOS(resList);
                    logger.info(JSONObject.toJSONString(resultVO, SerializerFeature.PrettyFormat));
                    logger.info("================================================");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        List<AiReceiptVO> receiptVOS = resultVO.getReceiptVOS();
        if (CollectionUtils.isEmpty(receiptVOS)) {
            resultVO.setMsg("未识别到图片中的物料信息！");
            resultVO.setCode(1);
        } else {
            resultVO.setMsg("物料匹配中...");
            receiptAiService.identifyMaterial(resultVO, APP_ID, SECRET_KEY);
        }
        receiptAiService.saveResultToCache(resultVO);
        return resultVO;
    }


    /**
     * @description: 获取历史识别结果
     *
     * @param fileId 文件ID
     * @return {@link AiReceiptResultVO}
     * @author songlx
     * @date: 2025/2/25
     */
    @RequestMapping(value = "queryResult", method = RequestMethod.GET)
    public AiReceiptResultVO queryResult(@RequestParam String fileId) {
        return receiptAiService.getResultFromCache(fileId);
    }






    public static BigDecimal toBigDecimal(Object x) {
        if (x == null) {
            return null;
        } else {
            BigDecimal result = null;

            try {
                result = new BigDecimal(x.toString());
            } catch (Exception var3) {
            }
            return result;
        }
    }

}



