package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.api.param.ChatParam;
import com.ejianc.foundation.ai.bean.*;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.AgentMapper;
import com.ejianc.foundation.ai.service.*;
import com.ejianc.foundation.ai.sse.helper.SSEEmitterHelper;
import com.ejianc.foundation.ai.utils.QianfanUtils;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.vdurmont.emoji.EmojiParser;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.MessageWindowChatMemory;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.ollama.OllamaStreamingChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.qianfan.QianfanChatModel;
import dev.langchain4j.model.qianfan.QianfanStreamingChatModel;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * AI智能体表
 *
 * @author generator
 *
 */
@Service("agentService")
public class AgentServiceImpl extends BaseServiceImpl<AgentMapper, AgentEntity> implements IAgentService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IModelService modelService;
    @Autowired
    private IKnowledgeMessageHistoryService KnowledgeMessageHistoryService;
    @Autowired
    private IKnowledgeMessageService knowledgeMessageService;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private SSEEmitterHelper sseEmitterHelper;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;

    private void saveKnowledgeMessage(Long pkId, Long knowledgeId, Long dialogId,Long userId,Long tenantId, String resStr) {
        KnowledgeMessageEntity answerMessageEntity = new KnowledgeMessageEntity();
        answerMessageEntity.setId(pkId);
        answerMessageEntity.setParentId(knowledgeId);
        answerMessageEntity.setContent(resStr);
        answerMessageEntity.setUserId(userId);
        answerMessageEntity.setMessageHistoryId(dialogId);
        answerMessageEntity.setTenantId(tenantId);
        knowledgeMessageService.saveOrUpdate(answerMessageEntity,false);
    }

    public CommonResponse<JSONObject> chatWithAgentByApi(ChatParam chatParam) {
        if(chatParam.getAgentId() == null) {
            return CommonResponse.error("智能体ID不能为空！");
        }
        AgentEntity agentEntity = this.selectById(chatParam.getAgentId());
        if(agentEntity == null) {
            return CommonResponse.error("找不到对应的智能体！");
        }
        if(agentEntity.getAgentState()==0){
            return CommonResponse.error("当前智能体已被停用！");
        }
        if(StringUtils.isBlank(chatParam.getReqText())) {
            return CommonResponse.error("请求内容不能为空！");
        }
        ModelEntity model = modelService.selectById(agentEntity.getModelId());
        if(model == null){
            return CommonResponse.error("当前智能体没有设置大模型，无法回答问题！");
        }
        if(model.getModelState()!=1){
            return CommonResponse.error("当前智能体引用的大模型已经被停用了！");
        }
        Long userId = InvocationInfoProxy.getUserid();
        Long tenantId = InvocationInfoProxy.getTenantid();

        Long dialogId = IdWorker.getId();
        KnowledgeMessageHistoryEntity historyEntity = new KnowledgeMessageHistoryEntity();
        historyEntity.setId(dialogId);
        historyEntity.setAgentId(agentEntity.getId());
        historyEntity.setUserId(userId);
        historyEntity.setTopFlag(0);
        historyEntity.setTitle(chatParam.getReqText());
        KnowledgeMessageHistoryService.saveOrUpdate(historyEntity,false);

        Long knowledgeMessageId = IdWorker.getId();
        KnowledgeMessageEntity answerMessageEntity = new KnowledgeMessageEntity();
        answerMessageEntity.setId(knowledgeMessageId);
        answerMessageEntity.setContent(chatParam.getReqText());
        answerMessageEntity.setUserId(userId);
        answerMessageEntity.setMessageHistoryId(dialogId);
        answerMessageEntity.setCreateTime(new Date());
        knowledgeMessageService.saveOrUpdate(answerMessageEntity,false);

        StringBuilder contextSbf = new StringBuilder();
        String knowledgeIds = agentEntity.getKnowledgeIds();

        List<String> embeddingIds = new ArrayList<>();
        if(StringUtils.isNotBlank(knowledgeIds)){
            String[] knowledgeIdArr = knowledgeIds.split(",");
            for (String knowledgeId : knowledgeIdArr) {
                KnowledgeBaseEntity knowledgeBaseEntity = knowledgeBaseService.selectById(knowledgeId);

                Embedding queryEmbedding = ejcAiEmbeding.getEmbeddingModel(knowledgeBaseEntity.getCode()).embed(chatParam.getReqText()).content();
                EmbeddingSearchRequest embeddingSearchRequest = EmbeddingSearchRequest.builder().queryEmbedding(queryEmbedding).minScore(agentEntity.getMatchScore().doubleValue()).maxResults(agentEntity.getCallBackNum()).build();
                EmbeddingSearchResult<TextSegment> embeddedEmbeddingSearchResult = ejcAiEmbeding.getEmbeddingStore(knowledgeBaseEntity.getCode()).search(embeddingSearchRequest);
                List<EmbeddingMatch<TextSegment>> embeddingMatcheList = embeddedEmbeddingSearchResult.matches();
                if(embeddingMatcheList.size() > 0) {
                    for(EmbeddingMatch<TextSegment> embeddingMatch : embeddingMatcheList) {
                        TextSegment textSegment = embeddingMatch.embedded();
                        if(StringUtils.isNotBlank(textSegment.text())) {
                            embeddingIds.add(knowledgeBaseEntity.getCode()+":"+embeddingMatch.embeddingId());
                            contextSbf.append(textSegment.text()).append(";");
                        }
                    }
                }
            }
        }

        if(1 == agentEntity.getStrictFlag() && StringUtils.isBlank(contextSbf + "")) {
            return CommonResponse.error("当前知识库没有您提问的知识！");
        }

        PromptTemplate promptTemplate = PromptTemplate.from("{{template}}\n" +
                ", 基于如下信息进行回答:\n" +
                "{{context}}\n" +
                "提问:\n" +
                "{{question}}");
        Map<String, Object> variables = new HashMap<>();
        variables.put("template", agentEntity.getRoleInstruction());
        variables.put("context", contextSbf + "");
        variables.put("question", chatParam.getReqText());
        Prompt prompt = promptTemplate.apply(variables);
        UserMessage userMessage = prompt.toUserMessage();

        if(1 == model.getPlatform()) { //本地大模型
            OllamaChatModel ollamaChatModel = OllamaChatModel.builder()
                    .baseUrl(model.getBaseUrl())
                    .modelName(model.getModelName())
                    .numPredict(-1)
                    .temperature(agentEntity.getTemperature().doubleValue())
                    .build();

            Response<AiMessage> messageResponse = ollamaChatModel.generate(userMessage);
            String resStr = messageResponse.content().text();
            if(StringUtils.isNotBlank(resStr) && resStr.contains("</think>")) {
                String[] respStrArr = resStr.split("</think>");
                resStr = respStrArr[1];
            }
            resStr = EmojiParser.removeAllEmojis(resStr);
            Long pkId = IdWorker.getId();
            saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
            return CommonResponse.success(resStr);
        }else if(2 == model.getPlatform()) { //qianfan大模型
            String appConfig = model.getAppConfig();
            try{
                JSONObject appConfigJson = JSONObject.parseObject(appConfig);
                String apiKey = appConfigJson.getString("apiKey");
                String secretKey = appConfigJson.getString("secretKey");

                QianfanChatModel qianfanChatModel = QianfanChatModel.builder()
                        .modelName(model.getModelName())
                        .apiKey(apiKey)
                        .secretKey(secretKey)
                        .temperature(agentEntity.getTemperature().doubleValue())
                        .build();

                Response<AiMessage> messageResponse = qianfanChatModel.generate(userMessage);
                String resStr = messageResponse.content().text();
                if(StringUtils.isNotBlank(resStr) && resStr.contains("</think>")) {
                    String[] respStrArr = resStr.split("</think>");
                    resStr = respStrArr[1];
                }
                resStr = EmojiParser.removeAllEmojis(resStr);
                Long pkId = IdWorker.getId();
                saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
                return CommonResponse.success(resStr);
            }catch(Exception e) {
                return CommonResponse.error("千帆大模型配置信息有误，例子: {\"appId\":\"\",\"appSecret\":\"\"}！");
            }
        }else if(3 == model.getPlatform()) { // 阿里百练大模型
            String appConfig = model.getAppConfig();
            try{
                JSONObject appConfigJson = JSONObject.parseObject(appConfig);
                String apiKey = appConfigJson.getString("apiKey");

                OpenAiChatModel openAiChatModel = OpenAiChatModel.builder()
                        .modelName(model.getModelName())
                        .apiKey(apiKey)
                        .temperature(agentEntity.getTemperature().doubleValue())
                        .build();

                Response<AiMessage> messageResponse = openAiChatModel.generate(userMessage);
                String resStr = messageResponse.content().text();
                if(StringUtils.isNotBlank(resStr) && resStr.contains("</think>")) {
                    String[] respStrArr = resStr.split("</think>");
                    resStr = respStrArr[1];
                }
                resStr = EmojiParser.removeAllEmojis(resStr);
                Long pkId = IdWorker.getId();
                saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
                return CommonResponse.success(resStr);
            }catch(Exception e) {
                return CommonResponse.error("阿里大模型配置信息有误，例子: {\"appId\":\"\",\"appSecret\":\"\"}！");
            }
        }else{
            return CommonResponse.error("该智能体设置的大模型没有对应的实现！");
        }
    }

    @Override
    public SseEmitter chatWithAgent(String text, Long agentId, Long dialogId, Long knowledgeSessionId) {
        SseEmitter sseEmitter = new SseEmitter(6000000L);

        AgentEntity agentEntity = this.selectById(agentId);
        JSONObject res = new JSONObject();
        int sequence = 0;
        Long userId = InvocationInfoProxy.getUserid();
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(dialogId == null){
            /** 新建对话 */
            dialogId = IdWorker.getId();
            KnowledgeMessageHistoryEntity historyEntity = new KnowledgeMessageHistoryEntity();
            historyEntity.setId(dialogId);
            historyEntity.setAgentId(agentId);
            historyEntity.setUserId(userId);
            historyEntity.setTopFlag(0);
            historyEntity.setTitle(text);
            KnowledgeMessageHistoryService.saveOrUpdate(historyEntity,false);
        }

        KnowledgeMessageEntity answerMessageEntity = null;
        Long knowledgeMessageId = null;
        if(knowledgeSessionId == null) {
            knowledgeMessageId = IdWorker.getId();
            answerMessageEntity = new KnowledgeMessageEntity();
            answerMessageEntity.setId(knowledgeMessageId);
            answerMessageEntity.setContent(text);
            answerMessageEntity.setUserId(InvocationInfoProxy.getUserid());
            answerMessageEntity.setMessageHistoryId(dialogId);
            answerMessageEntity.setCreateTime(new Date());
            knowledgeMessageService.saveOrUpdate(answerMessageEntity,false);
        }else{
            answerMessageEntity = knowledgeMessageService.selectById(knowledgeSessionId);
            knowledgeMessageId = answerMessageEntity.getId();
        }

        String resStr = "";
        /** 保存用户对话 */
        if(agentEntity == null){
            resStr = "找不到对应的智能体";
            Long pkId = IdWorker.getId();
            saveKnowledgeMessage(pkId,knowledgeMessageId, dialogId, userId, tenantId, resStr);
            res.put("botMsg",resStr);
            res.put("dialogId",dialogId);
            res.put("knowledgeMessageId",knowledgeMessageId);
            res.put("currentAnswerId",pkId);

            String respKey = "RESP_ANSWER:"+pkId;
            redisTemplate.opsForValue().set(respKey, "true",30, TimeUnit.MINUTES);

            sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
        if(agentEntity.getAgentState()==0){
            resStr = "当前访问的智能体已被停用了！";
            Long pkId = IdWorker.getId();
            saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
            res.put("botMsg",resStr);
            res.put("dialogId",dialogId);
            res.put("knowledgeMessageId",knowledgeMessageId);
            res.put("currentAnswerId",pkId);

            String respKey = "RESP_ANSWER:"+pkId;
            redisTemplate.opsForValue().set(respKey, "true",30, TimeUnit.MINUTES);

            sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
        ModelEntity model = modelService.selectById(agentEntity.getModelId());
        if(model == null){
            resStr = "当前智能体没有设置大模型，无法回答问题！";
            Long pkId = IdWorker.getId();
            saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
            res.put("botMsg",resStr);
            res.put("dialogId",dialogId);
            res.put("knowledgeMessageId",knowledgeMessageId);
            res.put("currentAnswerId",pkId);

            String respKey = "RESP_ANSWER:"+pkId;
            redisTemplate.opsForValue().set(respKey, "true",30, TimeUnit.MINUTES);

            sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
        if(model.getModelState()!=1){
            resStr = "当前智能体引用的大模型已经被停用了！";
            Long pkId = IdWorker.getId();
            saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
            res.put("botMsg",resStr);
            res.put("dialogId",dialogId);
            res.put("knowledgeMessageId",knowledgeMessageId);
            res.put("currentAnswerId",pkId);

            String respKey = "RESP_ANSWER:"+pkId;
            redisTemplate.opsForValue().set(respKey, "true",30, TimeUnit.MINUTES);

            sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
        StringBuilder contextSbf = new StringBuilder();
        String knowledgeIds = agentEntity.getKnowledgeIds();

        List<String> embeddingIds = new ArrayList<>();
        if(StringUtils.isNotBlank(knowledgeIds)){
            String[] knowledgeIdArr = knowledgeIds.split(",");
            for (String knowledgeId : knowledgeIdArr) {
                KnowledgeBaseEntity knowledgeBaseEntity = knowledgeBaseService.selectById(knowledgeId);

                Embedding queryEmbedding = ejcAiEmbeding.getEmbeddingModel(knowledgeBaseEntity.getCode()).embed(text).content();
                EmbeddingSearchRequest embeddingSearchRequest = EmbeddingSearchRequest.builder().queryEmbedding(queryEmbedding).minScore(agentEntity.getMatchScore().doubleValue()).maxResults(agentEntity.getCallBackNum()).build();
                EmbeddingSearchResult<TextSegment> embeddedEmbeddingSearchResult = ejcAiEmbeding.getEmbeddingStore(knowledgeBaseEntity.getCode()).search(embeddingSearchRequest);
                List<EmbeddingMatch<TextSegment>> embeddingMatcheList = embeddedEmbeddingSearchResult.matches();
                if(embeddingMatcheList.size() > 0) {
                    for(EmbeddingMatch<TextSegment> embeddingMatch : embeddingMatcheList) {
                        TextSegment textSegment = embeddingMatch.embedded();
                        if(StringUtils.isNotBlank(textSegment.text())) {
                            embeddingIds.add(knowledgeBaseEntity.getCode()+":"+embeddingMatch.embeddingId());
                            contextSbf.append(textSegment.text()).append(";");
                        }
                    }
                }
            }
        }

        if(1 == agentEntity.getStrictFlag() && StringUtils.isBlank(contextSbf + "")) {
            resStr = "当前知识库没有您提问的知识！";
            Long pkId = IdWorker.getId();
            saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);

            res.put("botMsg",resStr);
            res.put("dialogId",dialogId);
            res.put("knowledgeMessageId",knowledgeMessageId);
            res.put("currentAnswerId",pkId);

            String respKey = "RESP_ANSWER:"+pkId;
            redisTemplate.opsForValue().set(respKey, "true",30, TimeUnit.MINUTES);

            sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }

        PromptTemplate promptTemplate = PromptTemplate.from("{{template}}\n" +
                ", 基于如下信息进行回答:\n" +
                "{{context}}\n" +
                "提问:\n" +
                "{{question}}");
        Map<String, Object> variables = new HashMap<>();
        variables.put("template", agentEntity.getRoleInstruction());
        variables.put("context", contextSbf + "");
        variables.put("question", text);
        Prompt prompt = promptTemplate.apply(variables);

        UserMessage userMessage = prompt.toUserMessage();
        ChatMemory chatMemory = MessageWindowChatMemory.withMaxMessages(5);
        // 最近一条历史对话
        KnowledgeMessageEntity latestHistoryMessage = knowledgeMessageService.queryParentHistoryList(dialogId, userId, knowledgeMessageId);
        if(latestHistoryMessage != null) {
            chatMemory.add(UserMessage.from(latestHistoryMessage.getContent()));
            //查询当前提问的回答
            QueryWrapper<KnowledgeMessageEntity> queryWrapperAnswer = new QueryWrapper<>();
            queryWrapperAnswer.eq("message_history_id", dialogId);
            queryWrapperAnswer.eq("user_id", userId);
            queryWrapperAnswer.eq("parent_id", latestHistoryMessage.getId());
            queryWrapperAnswer.orderByDesc("create_time");
            queryWrapperAnswer.last("limit 1"); //只取一条
            KnowledgeMessageEntity historyAnswer = knowledgeMessageService.getOne(queryWrapperAnswer);
            if(historyAnswer != null) {
                chatMemory.add(AiMessage.from(historyAnswer.getContent()));
            }
        }
        chatMemory.add(userMessage);

        if(1 == model.getPlatform()) { //本地大模型
            OllamaStreamingChatModel ollamaStreamingChatModel = OllamaStreamingChatModel.builder()
                    .baseUrl(model.getBaseUrl())
                    .modelName(model.getModelName())
                    //.numCtx(model.getMaxInputTokens() == null? 10000 : model.getMaxInputTokens())
                    .temperature(agentEntity.getTemperature().doubleValue())
                    .numPredict(-1)
                    .timeout(Duration.ofMinutes(50))
                    .build();


            final Long fdialogId = dialogId;
            final Long fPkId = IdWorker.getId();
            final Boolean[] fIsSetValue = {false};
            final Long fknowledgeMessageId = knowledgeMessageId;
            ollamaStreamingChatModel.generate(chatMemory.messages(), new StreamingResponseHandler<AiMessage>() {
                @Override
                public void onNext(String text) {
                    String respKey = "RESP_ANSWER:"+fPkId;
                    String isResponsing = String.valueOf(redisTemplate.opsForValue().get(respKey));
                    if(!"false".equals(isResponsing)) {
                        JSONObject resNext = new JSONObject();
                        resNext.put("dialogId",fdialogId);
                        resNext.put("botMsg", text);
                        resNext.put("knowledgeMessageId",fknowledgeMessageId);
                        resNext.put("currentAnswerId", fPkId);
                        if(!fIsSetValue[0]) {
                            fIsSetValue[0] = true;
                            redisTemplate.opsForValue().set(respKey, "true",30, TimeUnit.MINUTES);
                        }
                        sseEmitterHelper.sendComplete(sseEmitter, resNext);
                    }else{
                        sseEmitter.complete();
                        redisTemplate.delete(respKey);
                        throw new RuntimeException("用户取消了本次对话");
                    }
                }
                @Override
                public void onComplete(Response<AiMessage> response) {
                    String referenceHtml = "";
                    if(embeddingIds.size() > 0) {
                        StringBuilder embeddingIdsSbf = new StringBuilder("");
                        for(String embeddingId : embeddingIds) {
                            embeddingIdsSbf.append("'").append(embeddingId).append("'").append(",");
                        }
                        if(StringUtils.isNotBlank(embeddingIdsSbf + "")) {
                            List<KnowledgeItemEntity> knowledgeItemList = knowledgeItemService.queryKnowlegeItemList(embeddingIdsSbf.substring(0, embeddingIdsSbf.length() - 1));

                            if(knowledgeItemList != null && knowledgeItemList.size() > 0) {
                                referenceHtml += "<br/><br/> ****引用文档：**** \n\n";
                                for(int i=0;i<knowledgeItemList.size();i++) {
                                    KnowledgeItemEntity knowledgeItemEntity = knowledgeItemList.get(i);
                                    referenceHtml += "&nbsp;&nbsp;&nbsp;&nbsp;"+(i+1)+".&nbsp;["+knowledgeItemEntity.getFileName()+"]("+knowledgeItemEntity.getOnlinePath() + ") <br/>";
                                    knowledgeItemService.updateReferenceCount(knowledgeItemEntity.getId());
                                }
                                JSONObject resComplete = new JSONObject();
                                resComplete.put("dialogId",fdialogId);
                                resComplete.put("botMsg", referenceHtml);
                                resComplete.put("knowledgeMessageId",fknowledgeMessageId);
                                resComplete.put("currentAnswerId", fPkId);
                                sseEmitterHelper.sendComplete(sseEmitter, resComplete);
                            }
                        }
                    }
                    String respText = response.content().text() + referenceHtml;
                    Long pkId = IdWorker.getId();
                    if(StringUtils.isNotBlank(respText)) {
                        respText = respText.replace("<think>", "<p class=\"thinking-text-button\" onclick=\"thinkProgressIsHide('"+pkId+"');\">思考过程 <span class=\"chat-iconfont icon-up_x\"></span></p><div id=\""+pkId+"\"  class=\"think-text-content hide-content\">");
                        respText = respText.replace("</think>", "</div>");
                    }
                    respText = EmojiParser.removeAllEmojis(respText);
                    saveKnowledgeMessage(pkId, fknowledgeMessageId, fdialogId, userId, tenantId, respText);
                    sseEmitter.complete();
                    StreamingResponseHandler.super.onComplete(response);
                }
                @Override
                public void onError(Throwable throwable) {
                    logger.error("sseEmitter error", throwable);
                }
            });
            return sseEmitter;
        }else if(2 == model.getPlatform()) { //千帆大模型
            String appConfig = model.getAppConfig();
            JSONObject appConfigJson = JSONObject.parseObject(appConfig);
            String apiKey = appConfigJson.getString("apiKey");
            String secretKey = appConfigJson.getString("secretKey");

            QianfanStreamingChatModel qianfanStreamingChatModel = QianfanStreamingChatModel.builder()
                    .modelName(model.getModelName())
                    .apiKey(apiKey)
                    .secretKey(secretKey)
                    .temperature(agentEntity.getTemperature().doubleValue())
                    .build();

            final Long fdialogId = dialogId;
            final Long fPkId = IdWorker.getId();
            final Boolean[] fIsSetValue = {false};
            final Long fknowledgeMessageId = knowledgeMessageId;
            qianfanStreamingChatModel.generate(chatMemory.messages(), new StreamingResponseHandler<AiMessage>() {
                @Override
                public void onNext(String text) {
                    String respKey = "RESP_ANSWER:"+fPkId;
                    String isResponsing = String.valueOf(redisTemplate.opsForValue().get(respKey));
                    if(!"false".equals(isResponsing)) {
                        JSONObject resNext = new JSONObject();
                        resNext.put("dialogId",fdialogId);
                        resNext.put("botMsg", text);
                        resNext.put("knowledgeMessageId",fknowledgeMessageId);
                        resNext.put("currentAnswerId", fPkId);
                        if(!fIsSetValue[0]) {
                            fIsSetValue[0] = true;
                            redisTemplate.opsForValue().set(respKey, "true",30, TimeUnit.MINUTES);
                        }
                        sseEmitterHelper.sendComplete(sseEmitter, resNext);
                    }else{
                        sseEmitter.complete();
                        redisTemplate.delete(respKey);
                        throw new RuntimeException("用户取消了本次对话");
                    }
                }
                @Override
                public void onComplete(Response<AiMessage> response) {
                    String referenceHtml = "";
                    if(embeddingIds.size() > 0) {
                        StringBuilder embeddingIdsSbf = new StringBuilder("");
                        for(String embeddingId : embeddingIds) {
                            embeddingIdsSbf.append("'").append(embeddingId).append("'").append(",");
                        }
                        if(StringUtils.isNotBlank(embeddingIdsSbf + "")) {
                            List<KnowledgeItemEntity> knowledgeItemList = knowledgeItemService.queryKnowlegeItemList(embeddingIdsSbf.substring(0, embeddingIdsSbf.length() - 1));

                            if(knowledgeItemList != null && knowledgeItemList.size() > 0) {
                                referenceHtml += "<br/><br/> ****引用文档：**** \n\n";
                                for(int i=0;i<knowledgeItemList.size();i++) {
                                    KnowledgeItemEntity knowledgeItemEntity = knowledgeItemList.get(i);
                                    referenceHtml += "&nbsp;&nbsp;&nbsp;&nbsp;"+(i+1)+".&nbsp;["+knowledgeItemEntity.getFileName()+"]("+knowledgeItemEntity.getOnlinePath() + ") <br/>";
                                    knowledgeItemService.updateReferenceCount(knowledgeItemEntity.getId());
                                }
                                JSONObject resComplete = new JSONObject();
                                resComplete.put("dialogId",fdialogId);
                                resComplete.put("botMsg", referenceHtml);
                                resComplete.put("knowledgeMessageId",fknowledgeMessageId);
                                resComplete.put("currentAnswerId", fPkId);
                                sseEmitterHelper.sendComplete(sseEmitter, resComplete);
                            }
                        }
                    }
                    String respText = response.content().text() + referenceHtml;
                    Long pkId = IdWorker.getId();
                    if(StringUtils.isNotBlank(respText)) {
                        respText = respText.replace("<think>", "<p class=\"thinking-text-button\" onclick=\"thinkProgressIsHide('"+pkId+"');\">思考过程 <span class=\"chat-iconfont icon-up_x\"></span></p><div id=\""+pkId+"\"  class=\"think-text-content hide-content\">");
                        respText = respText.replace("</think>", "</div>");
                    }
                    respText = EmojiParser.removeAllEmojis(respText);
                    saveKnowledgeMessage(pkId, fknowledgeMessageId, fdialogId, userId, tenantId, respText);
                    sseEmitter.complete();
                    StreamingResponseHandler.super.onComplete(response);
                }
                @Override
                public void onError(Throwable throwable) {
                    logger.error("sseEmitter error", throwable);
                }
            });
            return sseEmitter;
        }else if(3 == model.getPlatform()){ // 阿里百练
            String appConfig = model.getAppConfig();
            JSONObject appConfigJson = JSONObject.parseObject(appConfig);
            String apiKey = appConfigJson.getString("apiKey");

            OpenAiStreamingChatModel openAiStreamingChatModel = OpenAiStreamingChatModel.builder()
                    .modelName(model.getModelName())
                    .apiKey(apiKey)
                    .temperature(agentEntity.getTemperature().doubleValue())
                    .build();

            final Long fdialogId = dialogId;
            final Long fPkId = IdWorker.getId();
            final Boolean[] fIsSetValue = {false};
            final Long fknowledgeMessageId = knowledgeMessageId;
            openAiStreamingChatModel.generate(chatMemory.messages(), new StreamingResponseHandler<AiMessage>() {
                @Override
                public void onNext(String text) {
                    String respKey = "RESP_ANSWER:"+fPkId;
                    String isResponsing = String.valueOf(redisTemplate.opsForValue().get(respKey));
                    if(!"false".equals(isResponsing)) {
                        JSONObject resNext = new JSONObject();
                        resNext.put("dialogId",fdialogId);
                        resNext.put("botMsg", text);
                        resNext.put("knowledgeMessageId",fknowledgeMessageId);
                        resNext.put("currentAnswerId", fPkId);
                        if(!fIsSetValue[0]) {
                            fIsSetValue[0] = true;
                            redisTemplate.opsForValue().set(respKey, "true",30, TimeUnit.MINUTES);
                        }
                        sseEmitterHelper.sendComplete(sseEmitter, resNext);
                    }else{
                        sseEmitter.complete();
                        redisTemplate.delete(respKey);
                        throw new RuntimeException("用户取消了本次对话");
                    }
                }
                @Override
                public void onComplete(Response<AiMessage> response) {
                    String referenceHtml = "";
                    if(embeddingIds.size() > 0) {
                        StringBuilder embeddingIdsSbf = new StringBuilder("");
                        for(String embeddingId : embeddingIds) {
                            embeddingIdsSbf.append("'").append(embeddingId).append("'").append(",");
                        }
                        if(StringUtils.isNotBlank(embeddingIdsSbf + "")) {
                            List<KnowledgeItemEntity> knowledgeItemList = knowledgeItemService.queryKnowlegeItemList(embeddingIdsSbf.substring(0, embeddingIdsSbf.length() - 1));

                            if(knowledgeItemList != null && knowledgeItemList.size() > 0) {
                                referenceHtml += "<br/><br/> ****引用文档：**** \n\n";
                                for(int i=0;i<knowledgeItemList.size();i++) {
                                    KnowledgeItemEntity knowledgeItemEntity = knowledgeItemList.get(i);
                                    referenceHtml += "&nbsp;&nbsp;&nbsp;&nbsp;"+(i+1)+".&nbsp;["+knowledgeItemEntity.getFileName()+"]("+knowledgeItemEntity.getOnlinePath() + ") <br/>";
                                    knowledgeItemService.updateReferenceCount(knowledgeItemEntity.getId());
                                }
                                JSONObject resComplete = new JSONObject();
                                resComplete.put("dialogId",fdialogId);
                                resComplete.put("botMsg", referenceHtml);
                                resComplete.put("knowledgeMessageId",fknowledgeMessageId);
                                resComplete.put("currentAnswerId", fPkId);
                                sseEmitterHelper.sendComplete(sseEmitter, resComplete);
                            }
                        }
                    }
                    String respText = response.content().text() + referenceHtml;
                    Long pkId = IdWorker.getId();
                    if(StringUtils.isNotBlank(respText)) {
                        respText = respText.replace("<think>", "<p class=\"thinking-text-button\" onclick=\"thinkProgressIsHide('"+pkId+"');\">思考过程 <span class=\"chat-iconfont icon-up_x\"></span></p><div id=\""+pkId+"\"  class=\"think-text-content hide-content\">");
                        respText = respText.replace("</think>", "</div>");
                    }
                    respText = EmojiParser.removeAllEmojis(respText);
                    saveKnowledgeMessage(pkId, fknowledgeMessageId, fdialogId, userId, tenantId, respText);
                    sseEmitter.complete();
                    StreamingResponseHandler.super.onComplete(response);
                }
                @Override
                public void onError(Throwable throwable) {
                    logger.error("sseEmitter error", throwable);
                }
            });
            return sseEmitter;
        }else{
            resStr = "该智能体设置的大模型没有对应的实现！";
            Long pkId = IdWorker.getId();
            saveKnowledgeMessage(pkId, knowledgeMessageId, dialogId, userId, tenantId, resStr);
            res.put("botMsg",resStr);
            res.put("dialogId",dialogId);
            res.put("knowledgeMessageId",knowledgeMessageId);
            res.put("currentAnswerId",pkId);

            String respKey = "RESP_ANSWER:"+pkId;
            redisTemplate.opsForValue().set(respKey, "true",30, TimeUnit.MINUTES);

            sseEmitterHelper.sendComplete(sseEmitter, res);
            sseEmitter.complete();
            return sseEmitter;
        }
    }
}
