package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.*;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeItemMapper;
import com.ejianc.foundation.ai.service.*;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.KnowledgeItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.splitter.DocumentByCharacterSplitter;
import dev.langchain4j.data.document.splitter.DocumentByParagraphSplitter;
import dev.langchain4j.data.document.splitter.DocumentByRegexSplitter;
import dev.langchain4j.data.document.splitter.DocumentSplitters;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * AI知识库文件
 *
 * @author generator
 *
 */
@Service("knowledgeItemService")
public class KnowledgeItemServiceImpl extends BaseServiceImpl<KnowledgeItemMapper, KnowledgeItemEntity> implements IKnowledgeItemService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DocumentSplitUtil documentSplitUtil;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;
    @Autowired
    private IKnowledgeItemTableIndexService knowledgeItemTableIndexService;
    @Autowired
    private KnowledgeItemMapper knowledgeItemMapper;

    public  String generateRandomString(int length) {
        String characters = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(length);

        for (int i = 0; i < length; i++) {
            int index = random.nextInt(characters.length());
            char randomChar = characters.charAt(index);
            sb.append(randomChar);
        }

        return sb.toString();
    }

    private String generateCode(){
        String code = "";
        try{
            String str = generateRandomString(10);
            code = str;
            boolean flag = true;
            while (flag){
                QueryWrapper<KnowledgeItemEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("file_code", code);
                wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());

                List<KnowledgeItemEntity> list = knowledgeItemMapper.selectList(wrapper);
                if(list!=null && list.size()>0){
                    code = str + generateRandomString(4);
                }else{
                    flag = false;
                }
            }
        }catch (Exception e){
            logger.info("生成编码失败:{}",e);
            throw new BusinessException("生成编码失败");
        }
        return code;
    }

    @Override
    public KnowledgeItemVO insert(KnowledgeItemVO saveOrUpdateVO) {
        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.selectById(saveOrUpdateVO.getKnowledgeBaseId());
        String indexName = knowledgeBase.getCode();
        KnowledgeItemEntity entity = BeanMapper.map(saveOrUpdateVO, KnowledgeItemEntity.class);
        if(saveOrUpdateVO.getId()==null){
            entity.setId(IdWorker.getId());
            entity.setFileCode(generateCode());
            entity.setUploadUserId(InvocationInfoProxy.getUserid());
        }

        //加载文件内容
        Document document = documentSplitUtil.loadDocument(entity.getFileSuffix(), entity.getFilePath());
        if(StringUtils.isBlank(entity.getBrief())) {
            if(StringUtils.isNotBlank(document.text())){
                if(document.text().length()>300){
                    entity.setBrief(document.text().substring(0, 300));
                }else{
                    entity.setBrief(document.text());
                }
            }
        }

        if(entity.getKnowledgeType() == 1){

            entity.setEmbeddingStatus(2);
            this.saveOrUpdate(entity, false);

            Map<String, Object> invocationInfo = new HashMap<>();
            invocationInfo.put("authority", InvocationInfoProxy.getExtendAttribute("authority"));
            invocationInfo.put("callid", InvocationInfoProxy.getCallid());
            invocationInfo.put("tenantid", InvocationInfoProxy.getTenantid());
            invocationInfo.put("employeeId", InvocationInfoProxy.getEmployeeId());
            invocationInfo.put("locale", InvocationInfoProxy.getLocale());
            invocationInfo.put("logints", InvocationInfoProxy.getLogints());
            invocationInfo.put("orgId", InvocationInfoProxy.getOrgId());
            invocationInfo.put("sysid", InvocationInfoProxy.getSysid());
            invocationInfo.put("theme", InvocationInfoProxy.getTheme());
            invocationInfo.put("timeZone", InvocationInfoProxy.getTimeZone());
            invocationInfo.put("usercode", InvocationInfoProxy.getUsercode());
            invocationInfo.put("userid", InvocationInfoProxy.getUserid());
            invocationInfo.put("userType", InvocationInfoProxy.getUserType());
            //文本型知识库
            Runnable task = () -> {
                InvocationInfoProxy.setCallid(invocationInfo.get("callid")!=null?invocationInfo.get("callid").toString():null);
                InvocationInfoProxy.setTenantid(invocationInfo.get("tenantid")!=null?Long.parseLong(invocationInfo.get("tenantid").toString()):null);
                InvocationInfoProxy.setEmployeeId(invocationInfo.get("employeeId")!=null?Long.parseLong(invocationInfo.get("employeeId").toString()):null);
                InvocationInfoProxy.setLocale(invocationInfo.get("locale")!=null?invocationInfo.get("locale").toString():null);
                InvocationInfoProxy.setLogints(invocationInfo.get("logints")!=null?invocationInfo.get("logints").toString():null);
                InvocationInfoProxy.setOrgId(invocationInfo.get("orgId")!=null?Long.parseLong(invocationInfo.get("orgId").toString()):null);
                InvocationInfoProxy.setSysid(invocationInfo.get("sysid")!=null?invocationInfo.get("sysid").toString():null);
                InvocationInfoProxy.setTheme(invocationInfo.get("theme")!=null?invocationInfo.get("theme").toString():null);
                InvocationInfoProxy.setTimeZone(invocationInfo.get("timeZone")!=null?invocationInfo.get("timeZone").toString():null);
                InvocationInfoProxy.setUsercode(invocationInfo.get("usercode")!=null?invocationInfo.get("usercode").toString():null);
                InvocationInfoProxy.setUserid(invocationInfo.get("userid")!=null?Long.parseLong(invocationInfo.get("userid").toString()):null);
                InvocationInfoProxy.setUserType(invocationInfo.get("userType")!=null?invocationInfo.get("userType").toString():null);

                InvocationInfoProxy.setExtendAttribute("authority", invocationInfo.get("authority")!=null?invocationInfo.get("authority").toString():null);

                List<String> allRedisIds = new ArrayList<>();
                try {
                    DocumentSplitter documentSplitter = null;
                    if (entity.getSliceStrategy() == 0) {
                        //默认切片
                        documentSplitter = DocumentSplitters.recursive(entity.getSliceMaxLength(), entity.getSliceOverlap());
                    } else {
                        if (StringUtils.isBlank(entity.getSliceIdentifier())) {
                            throw new BusinessException("标识符不能为空");
                        }
                        //自定义切片策咯
                        if ("char".equals(entity.getSliceIdentifier())) {
                            //按字符切分
                            documentSplitter = new DocumentByCharacterSplitter(entity.getSliceMaxLength(), entity.getSliceOverlap());
                        } else if ("paragraph".equals(entity.getSliceIdentifier())) {
                            //按段落切分
                            documentSplitter = new DocumentByParagraphSplitter(Integer.MAX_VALUE, entity.getSliceOverlap());
                        } else if ("regex".equals(entity.getSliceIdentifier()) || "fixedChar".equals(entity.getSliceIdentifier())) {
                            //按正则表达式切分
                            documentSplitter = new DocumentByRegexSplitter(entity.getSliceExpression(), "", Integer.MAX_VALUE, entity.getSliceOverlap());
                        } else {
                            throw new BusinessException("暂不支持该切片策咯");
                        }
                    }
                    EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
                    //// 创建一个内存中的嵌入存储
                    EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);

                    JSONObject json = documentSplitUtil.documentSplitStore(document, documentSplitter, embeddingModel, embeddingStore);

                    List segments = (List) json.get("segments");
                    List embeddings = (List) json.get("embeddings");
                    allRedisIds = (List) json.get("redisIds");

                    List<KnowledgeEmbeddingEntity> list = new ArrayList<>();
                    List<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<>();
                    for (int i = 0; i < segments.size(); i++) {
                        TextSegment segment = (TextSegment) segments.get(i);
                        Embedding embedding = (Embedding) embeddings.get(i);
                        String id = (String) allRedisIds.get(i);

                        KnowledgeEmbeddingEntity e = new KnowledgeEmbeddingEntity();
                        e.setId(IdWorker.getId());
                        e.setUuid(indexName + ":" + id);
                        e.setItemId(entity.getId());
                        e.setContent(segment.text());
                        e.setInitContent(segment.text());
                        e.setSliceState(1);
                        e.setType(1);
                        e.setSequence(segments.size()-i);
                        list.add(e);

                        KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                        p.setEmbeddingId(e.getId());
                        p.setUuid(indexName + ":" + id);
                        p.setContent(segment.text());
                        p.setInitContent(segment.text());
                        p.setVector(Arrays.toString(embedding.vector()));
                        p.setType(1);
                        p.setSequence(1);
                        listPoints.add(p);
                    }
                    if (list != null && list.size() > 0) {
                        knowledgeEmbeddingService.saveOrUpdateBatch(list, list.size(), false);
                        knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                    }
                    entity.setEmbeddingCount(segments.size());
                    entity.setEmbeddingStatus(3);
                    this.saveOrUpdate(entity, false);
                }catch (Exception e){
                    logger.error("生成向量数据库信息失败：{}",e);
                    entity.setEmbeddingStatus(4);
                    this.saveOrUpdate(entity, false);
                    //删除生成的向量数据库信息
                    EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
                    embeddingStore.removeAll(allRedisIds);
                    throw new BusinessException("生成向量数据库信息失败");
                }
            };
            new Thread(task).start();
        }else{
            entity.setEmbeddingStatus(1);
            this.saveOrUpdate(entity, false);
            //表格型知识库
            String[] allText = document.text().split("\n");
            //第0行是页签名称
            if(allText.length<2){
                throw new BusinessException("未获取到文件数据，请确认数据是否正确");
            }
            String[] titles = allText[1].split("\t");

            //保存索引信息
            KnowledgeItemTableIndexEntity indexEntity = new KnowledgeItemTableIndexEntity();
            indexEntity.setItemId(entity.getId());
            indexEntity.setTitles(String.join(",", titles));
            knowledgeItemTableIndexService.saveOrUpdate(indexEntity, false);
        }

        KnowledgeItemVO vo = BeanMapper.map(entity, KnowledgeItemVO.class);
        return vo;
    }

    @Override
    public KnowledgeItemVO saveData(KnowledgeItemVO saveOrUpdateVO) {
        KnowledgeItemEntity entity = knowledgeItemMapper.selectById(saveOrUpdateVO.getId());
        entity.setBrief(saveOrUpdateVO.getBrief());
        entity.setFileState(saveOrUpdateVO.getFileState());
        entity.setSequence(saveOrUpdateVO.getSequence());
        this.saveOrUpdate(entity, false);
        KnowledgeItemVO vo = BeanMapper.map(entity, KnowledgeItemVO.class);
        return vo;
    }

    @Override
    public void delData(List<Long> ids) {
        QueryWrapper<KnowledgeEmbeddingEntity> wrapperEmbedding = new QueryWrapper<>();
        wrapperEmbedding.in("item_id", ids);
        List<KnowledgeEmbeddingEntity> list = knowledgeEmbeddingService.list(wrapperEmbedding);
        if(list!=null && list.size()>0){
            List<Long> embeddingIds = new ArrayList<>();
            list.forEach(item -> {
                embeddingIds.add(item.getId());
            });
            QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapperEmbeddingPoints = new QueryWrapper<>();
            wrapperEmbeddingPoints.in("embedding_id", embeddingIds);
            List<KnowledgeEmbeddingPointsEntity> points = knowledgeEmbeddingPointsService.list(wrapperEmbeddingPoints);

            KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(ids.get(0));
            String indexName = knowledgeBase.getCode();

            if(points!=null && points.size()>0){
                List<String> rids = new ArrayList<>();
                points.forEach(item -> {
                    rids.add(item.getUuid());
                });
                EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
                embeddingStore.removeAll(rids);
            }
            knowledgeEmbeddingService.remove(wrapperEmbedding);
            knowledgeEmbeddingPointsService.remove(wrapperEmbeddingPoints);
        }
        this.removeByIds(ids,true);
    }

    public List<KnowledgeItemEntity> queryKnowlegeItemList(String embeddingIds) {
        List<KnowledgeItemEntity> itemList = knowledgeItemMapper.queryKnowlegeItemList(embeddingIds);
        return itemList;
    }

    @Override
    public void updateReferenceCount(Long id) {
        knowledgeItemMapper.updateReferenceCount(id);
    }

}
