package com.ejianc.foundation.ai.controller;

import java.io.Serializable;

import com.ejianc.foundation.ai.bean.BillInfoEntity;
import com.ejianc.foundation.ai.service.IBillInfoService;
import com.ejianc.foundation.ai.vo.BillInfoVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.kit.mapper.BeanMapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 单据信息表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("billInfo")
public class BillInfoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillInfoService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BillInfoVO> saveOrUpdate(@RequestBody BillInfoVO saveOrUpdateVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("code", Parameter.getEqInstance(saveOrUpdateVO.getCode()));
        param.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
        List<BillInfoEntity> list = service.queryList(param,false);
        if(ListUtil.isNotEmpty(list)){
            return CommonResponse.error("单据编号重复，请重新输入！");
        }
    	BillInfoEntity entity = BeanMapper.map(saveOrUpdateVO, BillInfoEntity.class);
    	service.saveOrUpdate(entity, false);
    	BillInfoVO vo = BeanMapper.map(entity, BillInfoVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BillInfoVO> queryDetail(Long id) {
    	BillInfoEntity entity = service.selectById(id);
    	BillInfoVO vo = BeanMapper.map(entity, BillInfoVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 处理搜索请求
     *
     * @param searchText 用户的搜索文本
     * @return 返回一个包含搜索结果的响应对象
     */
    @RequestMapping(value = "/search", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<String>> search(@RequestParam(required = false) String searchText) {
        QueryParam param = new QueryParam();
        if(StringUtils.isNotEmpty(searchText) && !Objects.equals(searchText,"#")){
            searchText = searchText.replace("#", "");
            param.getParams().put("billName", new Parameter(QueryParam.LIKE_LEFT, searchText));
        }
        param.setLimit(20);
        List<BillInfoEntity> list = service.queryList(param,false);
        List<String> res = ListUtil.isNotEmpty(list)?list.stream().map(BillInfoEntity::getBillName).map(str->"#"+str+"#").collect(Collectors.toList()): Lists.newArrayList();
        return CommonResponse.success("查询数据成功！",res);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillInfoVO> vos) {
        service.removeByIds(vos.stream().map(BillInfoVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BillInfoVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        IPage<BillInfoEntity> page = service.queryPage(param,false);
        IPage<BillInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BillInfoVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
}
