package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.vo.KnowledgeBaseVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

/**
 * AI知识库
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("knowledgeBase")
public class KnowledgeBaseController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IKnowledgeBaseService service;
    @Autowired
    private EnvironmentTools environmentTools;

    @Value("${refer.base-host:null}")
    private String baseHost;

    public  String generateRandomString(int length) {
        String characters = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(length);

        for (int i = 0; i < length; i++) {
            int index = random.nextInt(characters.length());
            char randomChar = characters.charAt(index);
            sb.append(randomChar);
        }

        return sb.toString();
    }

    private String generateCode(){
        String code = "";
        try{
            String str = generateRandomString(10);
            code = str;
            boolean flag = true;
            while (flag){
                QueryWrapper<KnowledgeBaseEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("code", code);
                wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());

                List<KnowledgeBaseEntity> list = service.list(wrapper);
                if(list!=null && list.size()>0){
                    code = str + generateRandomString(4);
                }else{
                    flag = false;
                }
            }
        }catch (Exception e){
            logger.info("生成编码失败:{}",e);
            throw new BusinessException("生成编码失败");
        }
        return code;
    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KnowledgeBaseVO> saveOrUpdate(@RequestBody KnowledgeBaseVO saveOrUpdateVO) {
    	KnowledgeBaseEntity entity = BeanMapper.map(saveOrUpdateVO, KnowledgeBaseEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            //新增
            String code = generateCode();
            entity.setCode(code);
            entity.setReferenceCount(0);
            service.saveOrUpdate(entity, false);

            return CommonResponse.success("保存成功");
        }else{
            KnowledgeBaseEntity uniqueBean = service.selectById(entity.getId());
            uniqueBean.setName(entity.getName());
            uniqueBean.setKnowledgeType(entity.getKnowledgeType());
            uniqueBean.setRetrieveMaxResults(entity.getRetrieveMaxResults());
            uniqueBean.setRetrieveMinScore(entity.getRetrieveMinScore());
            uniqueBean.setSequence(entity.getSequence());
            uniqueBean.setRemark(entity.getRemark());

            service.saveOrUpdate(uniqueBean, false);
            return CommonResponse.success("修改成功");
        }
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KnowledgeBaseVO> queryDetail(Long id) {
    	KnowledgeBaseEntity entity = service.selectById(id);
    	KnowledgeBaseVO vo = BeanMapper.map(entity, KnowledgeBaseVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        service.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KnowledgeBaseVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getOrderMap().put("sequence", QueryParam.ASC);
        param.getOrderMap().put("createTime", QueryParam.DESC);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<KnowledgeBaseEntity> page = service.queryPage(param,false);
        IPage<KnowledgeBaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), KnowledgeBaseVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/findByCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
        ReferVO refer = new ReferVO();
        String referBaseHost = "";
        if(StringUtils.isNotBlank(baseHost)&& !"null".equals(baseHost)){
            referBaseHost = baseHost;
        }else{
            referBaseHost = environmentTools.getBaseHost();
        }
        List<ReferShowfieldVO> gridHeaders = new ArrayList<ReferShowfieldVO>();
        ReferShowfieldVO idHeader = new ReferShowfieldVO();
        ReferShowfieldVO entityHeader = new ReferShowfieldVO();
        ReferShowfieldVO displayHeader = new ReferShowfieldVO();
        ReferShowfieldVO entityFullHeader = new ReferShowfieldVO();

        switch (refCode) {
            case "ai_knowledgebase_referList":
                refer.setRefCode("knowledgeBase");
                refer.setRefName("AI知识库");
                refer.setRefType("grid");
                refer.setDataurl(referBaseHost+"ejc-ai-web/knowledgeBase/queryKnowledgeBaseRefList");
                refer.setIdField("id");
                refer.setCodeField("code");
                refer.setNameField("name");
                refer.setId(new Date().getTime());

                idHeader.setId(1l);
                idHeader.setName("主键");
                idHeader.setCode("id");
                idHeader.setHidden(true);
                idHeader.setShowOrder(1);
                idHeader.setType("string");
                gridHeaders.add(idHeader);
                entityHeader.setId(2l);
                entityHeader.setName("知识库编码");
                entityHeader.setCode("code");
                entityHeader.setHidden(false);
                entityHeader.setShowOrder(1);
                entityHeader.setType("string");
                gridHeaders.add(entityHeader);
                displayHeader.setId(3l);
                displayHeader.setName("知识库名称");
                displayHeader.setCode("name");
                displayHeader.setHidden(false);
                displayHeader.setShowOrder(1);
                displayHeader.setType("string");
                gridHeaders.add(displayHeader);
                entityFullHeader.setId(4l);
                entityFullHeader.setName("知识库类型");
                entityFullHeader.setCode("knowledgeTypeName");
                entityFullHeader.setHidden(false);
                entityFullHeader.setShowOrder(1);
                entityFullHeader.setType("string");
                gridHeaders.add(entityFullHeader);
                refer.setGridheaders(gridHeaders);
                break;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", refer);
        return CommonResponse.success(refer);
    }

    @RequestMapping(value = "/queryKnowledgeBaseRefList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<KnowledgeBaseVO>> queryKnowledgeBaseRefList(@RequestParam(required = false) String condition,
                                                                                @RequestParam(required = false) String searchText,
                                                                                @RequestParam int pageSize,
                                                                                @RequestParam int pageNumber,
                                                                                @RequestParam(required=false) String relyCondition,
                                                                                @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("sequence", QueryParam.ASC);
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        IPage<KnowledgeBaseEntity> pageData = service.queryPage(queryParam);
        IPage<KnowledgeBaseVO> pageResult = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        if(pageData != null && pageData.getRecords() != null && pageData.getRecords().size() > 0) {
            List<KnowledgeBaseVO> knowledgeVos = new ArrayList<>();
            for(KnowledgeBaseEntity entity : pageData.getRecords()) {
                KnowledgeBaseVO knowledgeBaseVO = BeanMapper.map(entity, KnowledgeBaseVO.class);
                if(entity.getKnowledgeType() == 1) {
                    knowledgeBaseVO.setKnowledgeTypeName("文本型知识库");
                }else{
                    knowledgeBaseVO.setKnowledgeTypeName("表格型知识库");
                }
                knowledgeVos.add(knowledgeBaseVO);
            }
            pageResult.setRecords(knowledgeVos);
        }
        return CommonResponse.success("查询成功!", pageResult);
    }


    @RequestMapping(value = "/hitTest", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONArray> hitTest(@RequestParam String text, @RequestParam Long baseId) {
        return service.hitTest(baseId, text);
    }

}
