package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.KnowledgeItemEntity;
import com.ejianc.foundation.ai.service.IKnowledgeItemService;
import com.ejianc.foundation.ai.vo.KnowledgeItemVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.List;

/**
 * AI知识库文件
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("knowledgeItem")
public class KnowledgeItemController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IKnowledgeItemService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增
     */
    @RequestMapping(value = "/insert", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KnowledgeItemVO> insert(@RequestBody KnowledgeItemVO saveOrUpdateVO) {
        KnowledgeItemVO vo = service.insert(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Description saveOrUpdate 修改配置信息
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KnowledgeItemVO> save(@RequestBody KnowledgeItemVO saveOrUpdateVO) {
        KnowledgeItemVO vo = service.saveData(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KnowledgeItemVO> queryDetail(Long id) {
    	KnowledgeItemEntity entity = service.selectById(id);
    	KnowledgeItemVO vo = BeanMapper.map(entity, KnowledgeItemVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        service.delData(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KnowledgeItemVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("fileName");
        param.getOrderMap().put("sequence", QueryParam.ASC);
        param.getOrderMap().put("createTime", QueryParam.DESC);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<KnowledgeItemEntity> page = service.queryPage(param,false);
        IPage<KnowledgeItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), KnowledgeItemVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refKnowledgeItemData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<KnowledgeItemVO>> refKnowledgeItemData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<KnowledgeItemEntity> page = service.queryPage(param,false);
        IPage<KnowledgeItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), KnowledgeItemVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

     @RequestMapping(value = "/knowledgeItemDispatch", method = RequestMethod.POST)
     public CommonResponse<String> knowledgeItemDispatch(HttpServletRequest request) {
         service.insertKnowledgeItemDispatch(request);
        return CommonResponse.success("执行成功！");
     }


}
