package com.ejianc.foundation.ai.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.ai.api.param.ChatParam;
import com.ejianc.foundation.ai.service.IAgentService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/agent")
public class AgentApi {

    @Autowired
    private IAgentService agentService;

    @RequestMapping(value = "/chatWithAgentByApi", method = RequestMethod.POST)
    public CommonResponse<JSONObject> chatWithAgentByApi(@RequestBody ChatParam chatParam) {
        CommonResponse<JSONObject> response = agentService.chatWithAgentByApi(chatParam);
        return response;
    }
}
