package com.ejianc.foundation.ai.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.api.param.ChunkParam;
import com.ejianc.foundation.ai.api.param.KnowledgeBaseParam;
import com.ejianc.foundation.ai.api.param.KnowledgeItemParam;
import com.ejianc.foundation.ai.api.param.UpdateChunkParam;
import com.ejianc.foundation.ai.api.result.ChunkResult;
import com.ejianc.foundation.ai.api.result.KnowledgeItemResult;
import com.ejianc.foundation.ai.bean.*;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeEmbeddingMapper;
import com.ejianc.foundation.ai.mapper.KnowledgeItemMapper;
import com.ejianc.foundation.ai.service.*;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.splitter.DocumentByCharacterSplitter;
import dev.langchain4j.data.document.splitter.DocumentByParagraphSplitter;
import dev.langchain4j.data.document.splitter.DocumentByRegexSplitter;
import dev.langchain4j.data.document.splitter.DocumentSplitters;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.*;

@RestController
@RequestMapping("/api/knowledge")
public class KnowledgeApi {
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;
    @Autowired
    private IKnowledgeItemService knowledgeItemService;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;
    @Autowired
    private IKnowledgeItemTableIndexService knowledgeItemTableIndexService;
    @Autowired
    private KnowledgeEmbeddingMapper embeddingMapper;
    @Autowired
    private KnowledgeItemMapper knowledgeItemMapper;

    @RequestMapping(value = "/createKnowledgeBase", method = RequestMethod.POST)
    public CommonResponse<String> createKnowledgeBase(@RequestBody KnowledgeBaseParam knowledgeBaseParam) {
        KnowledgeBaseEntity knowledgeBaseEntity = new KnowledgeBaseEntity();
        knowledgeBaseEntity.setId(IdWorker.getId());
        knowledgeBaseEntity.setCode(knowledgeBaseParam.getKnowledgeBaseCode());
        knowledgeBaseEntity.setName(knowledgeBaseParam.getKnowledgeBaseName());
        knowledgeBaseEntity.setKnowledgeType(1);
        knowledgeBaseEntity.setRetrieveMaxResults(6);
        knowledgeBaseEntity.setRetrieveMinScore(new BigDecimal(0.6));
        knowledgeBaseEntity.setTenantId(999999L);
        knowledgeBaseEntity.setCreateUserCode("adminejc");
        knowledgeBaseService.save(knowledgeBaseEntity);

        return CommonResponse.success("创建成功");
    }

    private  String generateRandomString(int length) {
        String characters = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; i++) {
            int index = random.nextInt(characters.length());
            char randomChar = characters.charAt(index);
            sb.append(randomChar);
        }
        return sb.toString();
    }

    private String generateCode(){
        String code = "";
        try{
            String str = generateRandomString(10);
            code = str;
            boolean flag = true;
            while (flag){
                QueryWrapper<KnowledgeItemEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("file_code", code);
                wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
                List<KnowledgeItemEntity> list = knowledgeItemMapper.selectList(wrapper);
                if(list!=null && list.size()>0){
                    code = str + generateRandomString(4);
                }else{
                    flag = false;
                }
            }
        }catch (Exception e){
            throw new BusinessException("生成编码失败");
        }
        return code;
    }

    /**
     * 新增知识
     *
     * @return
     */
    @RequestMapping(value = "/createKnowledgeItem", method = RequestMethod.POST)
    public CommonResponse<KnowledgeItemResult> createKnowledgeItem(@RequestBody KnowledgeItemParam knowledgeItemParam) {
        if(StringUtils.isBlank(knowledgeItemParam.getKnowledgeBaseCode())) {
            throw new BusinessException("知识库编码不能为空");
        }
        QueryWrapper<KnowledgeBaseEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("code", knowledgeItemParam.getKnowledgeBaseCode());
        KnowledgeBaseEntity knowledgeBaseEntity = knowledgeBaseService.getOne(queryWrapper);
        if(knowledgeBaseEntity == null) {
            throw new BusinessException("知识库编码不存在");
        }
        String indexName = knowledgeBaseEntity.getCode();

        KnowledgeItemEntity entity = new KnowledgeItemEntity();
        entity.setId(IdWorker.getId());
        entity.setKnowledgeBaseId(knowledgeBaseEntity.getId());
        entity.setFileCode(generateCode());
        entity.setFileName(knowledgeItemParam.getFileName());
        entity.setFilePath(knowledgeItemParam.getFilePath());
        entity.setCategoryId(knowledgeItemParam.getCategoryId());
        String suffix = knowledgeItemParam.getFilePath().substring(knowledgeItemParam.getFilePath().lastIndexOf(".") + 1);
        Document document = documentSplitUtil.loadDocument(entity.getFileSuffix(), entity.getFilePath());
        if(org.apache.commons.lang3.StringUtils.isBlank(entity.getBrief())) {
            if(org.apache.commons.lang3.StringUtils.isNotBlank(document.text())){
                if(document.text().length()>300){
                    entity.setBrief(document.text().substring(0, 300));
                }else{
                    entity.setBrief(document.text());
                }
            }
        }
        entity.setFileState(1);
        entity.setKnowledgeType(knowledgeBaseEntity.getKnowledgeType());

        if(1 == knowledgeBaseEntity.getKnowledgeType()) { //文本知识库
            entity.setEmbeddingStatus(2);
            knowledgeItemService.saveOrUpdate(entity, false);

            Map<String, Object> invocationInfo = new HashMap<>();
            invocationInfo.put("authority", InvocationInfoProxy.getExtendAttribute("authority"));
            invocationInfo.put("callid", InvocationInfoProxy.getCallid());
            invocationInfo.put("tenantid", InvocationInfoProxy.getTenantid());
            invocationInfo.put("employeeId", InvocationInfoProxy.getEmployeeId());
            invocationInfo.put("locale", InvocationInfoProxy.getLocale());
            invocationInfo.put("logints", InvocationInfoProxy.getLogints());
            invocationInfo.put("orgId", InvocationInfoProxy.getOrgId());
            invocationInfo.put("sysid", InvocationInfoProxy.getSysid());
            invocationInfo.put("theme", InvocationInfoProxy.getTheme());
            invocationInfo.put("timeZone", InvocationInfoProxy.getTimeZone());
            invocationInfo.put("usercode", InvocationInfoProxy.getUsercode());
            invocationInfo.put("userid", InvocationInfoProxy.getUserid());
            invocationInfo.put("userType", InvocationInfoProxy.getUserType());
            //文本型知识库
            Runnable task = () -> {
                InvocationInfoProxy.setCallid(invocationInfo.get("callid")!=null?invocationInfo.get("callid").toString():null);
                InvocationInfoProxy.setTenantid(invocationInfo.get("tenantid")!=null?Long.parseLong(invocationInfo.get("tenantid").toString()):null);
                InvocationInfoProxy.setEmployeeId(invocationInfo.get("employeeId")!=null?Long.parseLong(invocationInfo.get("employeeId").toString()):null);
                InvocationInfoProxy.setLocale(invocationInfo.get("locale")!=null?invocationInfo.get("locale").toString():null);
                InvocationInfoProxy.setLogints(invocationInfo.get("logints")!=null?invocationInfo.get("logints").toString():null);
                InvocationInfoProxy.setOrgId(invocationInfo.get("orgId")!=null?Long.parseLong(invocationInfo.get("orgId").toString()):null);
                InvocationInfoProxy.setSysid(invocationInfo.get("sysid")!=null?invocationInfo.get("sysid").toString():null);
                InvocationInfoProxy.setTheme(invocationInfo.get("theme")!=null?invocationInfo.get("theme").toString():null);
                InvocationInfoProxy.setTimeZone(invocationInfo.get("timeZone")!=null?invocationInfo.get("timeZone").toString():null);
                InvocationInfoProxy.setUsercode(invocationInfo.get("usercode")!=null?invocationInfo.get("usercode").toString():null);
                InvocationInfoProxy.setUserid(invocationInfo.get("userid")!=null?Long.parseLong(invocationInfo.get("userid").toString()):null);
                InvocationInfoProxy.setUserType(invocationInfo.get("userType")!=null?invocationInfo.get("userType").toString():null);

                InvocationInfoProxy.setExtendAttribute("authority", invocationInfo.get("authority")!=null?invocationInfo.get("authority").toString():null);

                List<String> allRedisIds = new ArrayList<>();
                try {
                    DocumentSplitter documentSplitter = null;
                    if (entity.getSliceStrategy() == 0) {
                        //默认切片
                        documentSplitter = DocumentSplitters.recursive(entity.getSliceMaxLength(), entity.getSliceOverlap());
                    } else {
                        if (org.apache.commons.lang3.StringUtils.isBlank(entity.getSliceIdentifier())) {
                            throw new BusinessException("标识符不能为空");
                        }
                        //自定义切片策咯
                        if ("char".equals(entity.getSliceIdentifier())) {
                            //按字符切分
                            documentSplitter = new DocumentByCharacterSplitter(entity.getSliceMaxLength(), entity.getSliceOverlap());
                        } else if ("paragraph".equals(entity.getSliceIdentifier())) {
                            //按段落切分
                            documentSplitter = new DocumentByParagraphSplitter(Integer.MAX_VALUE, entity.getSliceOverlap());
                        } else if ("regex".equals(entity.getSliceIdentifier()) || "fixedChar".equals(entity.getSliceIdentifier())) {
                            //按正则表达式切分
                            documentSplitter = new DocumentByRegexSplitter(entity.getSliceExpression(), "", Integer.MAX_VALUE, entity.getSliceOverlap());
                        } else {
                            throw new BusinessException("暂不支持该切片策咯");
                        }
                    }
                    //AllMiniLmL6V2EmbeddingModel（通常表示为all-MiniLM-L6-v2）是一个基于MiniLM架构的句子嵌入模型，以下是对该模型的详细介绍：
                    //all-MiniLM-L6-v2模型能够将句子和短段落映射到384维的稠密向量空间中，这些向量保留了文本的语义信息，使得模型能够用于各种NLP任务，如信息检索、聚类、语义搜索和句子相似度计算等。
                    EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
                    //// 创建一个内存中的嵌入存储
                    EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);

                    JSONObject json = documentSplitUtil.documentSplitStore(document, documentSplitter, embeddingModel, embeddingStore);

                    List segments = (List) json.get("segments");
                    List embeddings = (List) json.get("embeddings");
                    allRedisIds = (List) json.get("redisIds");

                    List<KnowledgeEmbeddingEntity> list = new ArrayList<>();
                    List<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<>();
                    for (int i = 0; i < segments.size(); i++) {
                        TextSegment segment = (TextSegment) segments.get(i);
                        Embedding embedding = (Embedding) embeddings.get(i);
                        String id = (String) allRedisIds.get(i);

                        KnowledgeEmbeddingEntity e = new KnowledgeEmbeddingEntity();
                        e.setId(IdWorker.getId());
                        e.setUuid(indexName + ":" + id);
                        e.setItemId(entity.getId());
                        e.setContent(segment.text());
                        e.setInitContent(segment.text());
                        e.setSliceState(1);
                        e.setType(1);
                        e.setSequence(segments.size()-i);
                        list.add(e);

                        KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                        p.setEmbeddingId(e.getId());
                        p.setUuid(indexName + ":" + id);
                        p.setContent(segment.text());
                        p.setInitContent(segment.text());
                        p.setVector(Arrays.toString(embedding.vector()));
                        p.setType(1);
                        p.setSequence(1);
                        listPoints.add(p);
                    }
                    if (list != null && list.size() > 0) {
                        knowledgeEmbeddingService.saveOrUpdateBatch(list, list.size(), false);
                        knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                    }
                    entity.setEmbeddingCount(segments.size());
                    entity.setEmbeddingStatus(3);
                    knowledgeItemService.saveOrUpdate(entity, false);
                }catch (Exception e){
                    entity.setEmbeddingStatus(4);
                    knowledgeItemService.saveOrUpdate(entity, false);
                    //删除生成的向量数据库信息
                    EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
                    embeddingStore.removeAll(allRedisIds);
                    throw new BusinessException("生成向量数据库信息失败");
                }
            };
            new Thread(task).start();
        }else if(2 == knowledgeBaseEntity.getKnowledgeType()) { // 表格知识库
            entity.setEmbeddingStatus(2);
            knowledgeItemService.saveOrUpdate(entity, false);

            Map<String, Object> invocationInfo = new HashMap<>();
            invocationInfo.put("authority", InvocationInfoProxy.getExtendAttribute("authority"));
            invocationInfo.put("callid", InvocationInfoProxy.getCallid());
            invocationInfo.put("tenantid", InvocationInfoProxy.getTenantid());
            invocationInfo.put("employeeId", InvocationInfoProxy.getEmployeeId());
            invocationInfo.put("locale", InvocationInfoProxy.getLocale());
            invocationInfo.put("logints", InvocationInfoProxy.getLogints());
            invocationInfo.put("orgId", InvocationInfoProxy.getOrgId());
            invocationInfo.put("sysid", InvocationInfoProxy.getSysid());
            invocationInfo.put("theme", InvocationInfoProxy.getTheme());
            invocationInfo.put("timeZone", InvocationInfoProxy.getTimeZone());
            invocationInfo.put("usercode", InvocationInfoProxy.getUsercode());
            invocationInfo.put("userid", InvocationInfoProxy.getUserid());
            invocationInfo.put("userType", InvocationInfoProxy.getUserType());

            Runnable task = () -> {
                InvocationInfoProxy.setCallid(invocationInfo.get("callid")!=null?invocationInfo.get("callid").toString():null);
                InvocationInfoProxy.setTenantid(invocationInfo.get("tenantid")!=null?Long.parseLong(invocationInfo.get("tenantid").toString()):null);
                InvocationInfoProxy.setEmployeeId(invocationInfo.get("employeeId")!=null?Long.parseLong(invocationInfo.get("employeeId").toString()):null);
                InvocationInfoProxy.setLocale(invocationInfo.get("locale")!=null?invocationInfo.get("locale").toString():null);
                InvocationInfoProxy.setLogints(invocationInfo.get("logints")!=null?invocationInfo.get("logints").toString():null);
                InvocationInfoProxy.setOrgId(invocationInfo.get("orgId")!=null?Long.parseLong(invocationInfo.get("orgId").toString()):null);
                InvocationInfoProxy.setSysid(invocationInfo.get("sysid")!=null?invocationInfo.get("sysid").toString():null);
                InvocationInfoProxy.setTheme(invocationInfo.get("theme")!=null?invocationInfo.get("theme").toString():null);
                InvocationInfoProxy.setTimeZone(invocationInfo.get("timeZone")!=null?invocationInfo.get("timeZone").toString():null);
                InvocationInfoProxy.setUsercode(invocationInfo.get("usercode")!=null?invocationInfo.get("usercode").toString():null);
                InvocationInfoProxy.setUserid(invocationInfo.get("userid")!=null?Long.parseLong(invocationInfo.get("userid").toString()):null);
                InvocationInfoProxy.setUserType(invocationInfo.get("userType")!=null?invocationInfo.get("userType").toString():null);

                InvocationInfoProxy.setExtendAttribute("authority", invocationInfo.get("authority")!=null?invocationInfo.get("authority").toString():null);

                List<String> allRedisIds = new ArrayList<>();
                try {
                    //创建索引字段，默认所有字段创建索引

                    //表格型知识库
                    String[] allText = document.text().split("\n");
                    //第0行是页签名称
                    if(allText.length<2){
                        throw new BusinessException("未获取到文件数据，请确认数据是否正确");
                    }
                    String[] titles = allText[1].split("\t");

                    KnowledgeItemTableIndexEntity tableIndexEntity = new KnowledgeItemTableIndexEntity();
                    tableIndexEntity.setItemId(entity.getId());
                    tableIndexEntity.setTitles(String.join(",", titles));
                    tableIndexEntity.setIndexs(String.join(",", titles));
                    knowledgeItemTableIndexService.saveOrUpdate(tableIndexEntity, false);

                    //表格型知识库
                    Integer embeddingCount = 0;
                    for(int i=1; i<allText.length; i++){
                        List<TextSegment> documents = new ArrayList<>();
                        List<KnowledgeEmbeddingEntity> embeddingEntitys = new ArrayList<>();
                        List<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<>();
                        String lineData = allText[i];
                        String[] items = lineData.split("\t");
                        if(i==1){
                            titles = items;
                        }else{
                            //具体数据
                            JSONObject ob = new JSONObject();
                            String o = "";
                            for(int j=0; j<items.length; j++){
                                o += (titles[j] + ": " +items[j] + " ");
                                ob.put(titles[j], items[j]);
                            }
                            TextSegment s = TextSegment.from(o);
                            documents.add(s);
                            Long embeddingId = IdWorker.getId();

                            KnowledgeEmbeddingEntity embeddingEntity = new KnowledgeEmbeddingEntity();
                            embeddingEntity.setItemId(entity.getId());
                            embeddingEntity.setId(embeddingId);
                            embeddingEntity.setType(1);
                            embeddingEntity.setSliceState(1);
                            embeddingEntity.setContent(o);
                            embeddingEntity.setInitContent(ob.toJSONString());
                            embeddingEntity.setTableContent(ob.toJSONString());
                            embeddingEntity.setSequence(allText.length-1-i);
                            embeddingEntitys.add(embeddingEntity);

                            for(int j=0; j<titles.length; j++){
                                String index = titles[j];
                                documents.add(TextSegment.from(index+": "+ob.getString(index)));
                            }

                            EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
                            //// 删除向量数据库中的信息
                            EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);

                            //执行文件切分
                            JSONObject json = documentSplitUtil.documentStoreList(documents, embeddingModel, embeddingStore);

                            List embeddings = (List) json.get("embeddings");
                            List redisIds = (List) json.get("redisIds");
                            allRedisIds.addAll(redisIds);
                            for(int j=0; j<documents.size(); j++){
                                TextSegment segment = documents.get(j);
                                Embedding embedding = (Embedding) embeddings.get(j);
                                String id = (String) redisIds.get(j);

                                KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                                p.setEmbeddingId(embeddingId);
                                p.setUuid(indexName+":"+id);
                                p.setContent(segment.text());
                                p.setInitContent(segment.text());
                                p.setVector(Arrays.toString(embedding.vector()));
                                p.setType(1);
                                p.setSequence(documents.size()-j);
                                listPoints.add(p);
                            }

                        }
                        if(embeddingEntitys!=null && embeddingEntitys.size()>0){
                            knowledgeEmbeddingService.saveOrUpdateBatch(embeddingEntitys, embeddingEntitys.size(), false);
                        }
                        if(listPoints!=null && listPoints.size()>0){
                            knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                        }
                        embeddingCount += listPoints.size();
                    }
                    entity.setEmbeddingStatus(3);
                    entity.setEmbeddingCount(embeddingCount);
                    knowledgeItemService.saveOrUpdate(entity, false);
                }catch (Exception e){
                    entity.setEmbeddingStatus(4);
                    knowledgeItemService.saveOrUpdate(entity, false);
                    //删除生成的向量数据库信息
                    EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
                    embeddingStore.removeAll(allRedisIds);
                    throw new BusinessException("生成向量数据库信息失败");
                }
            };
            new Thread(task).start();
        }
        KnowledgeItemResult result = new KnowledgeItemResult();
        result.setKnowledgeBaseCode(indexName);
        result.setKnowledgeItemName(entity.getFileName());
        result.setKnowledgeItemCode(entity.getFileCode());
        return CommonResponse.success(result);
    }

    /**
     * 新增切片
     *
     * @return
     */
    @RequestMapping(value = "/createChunk", method = RequestMethod.POST)
    public CommonResponse<ChunkResult> createChunk(@RequestBody ChunkParam chunkParam) {
        List<String> chunkContent = chunkParam.getChunkContent(); //分片内容
        QueryWrapper<KnowledgeBaseEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("code", chunkParam.getKnowledgeBaseCode());
        KnowledgeBaseEntity knowledgeBaseEntity = knowledgeBaseService.getOne(queryWrapper);
        if(knowledgeBaseEntity == null) {
            throw new BusinessException("知识库编码不存在");
        }
        QueryWrapper<KnowledgeItemEntity> itemWrapper = new QueryWrapper<>();
        itemWrapper.eq("code", chunkParam.getKnowledgeItemCode());
        KnowledgeItemEntity itemEntity = knowledgeItemService.getOne(itemWrapper);
        if(itemEntity == null) {
            throw new BusinessException("文件编号不存在");
        }
        String indexName = knowledgeBaseEntity.getCode();

        KnowledgeEmbeddingEntity entity = new KnowledgeEmbeddingEntity();
        //新增，新增向量+切片
        entity.setType(2);
        entity.setSliceState(1);
        Integer maxSequence = embeddingMapper.selectMaxSequence(itemEntity.getId());
        maxSequence++;

        EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
        //// 删除向量数据库中的信息
        EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
        List<JSONObject> chunkInfo = new ArrayList<>();
        for(String content : chunkContent){
            if(1 == knowledgeBaseEntity.getKnowledgeType()) { //文本知识库
                entity.setInitContent(content);
                entity.setSequence(maxSequence);
                //执行文件切分
                JSONObject json = documentSplitUtil.documentStoreSingle(entity.getContent(), embeddingModel, embeddingStore);
                Embedding embedding = (Embedding) json.get("embedding");
                String redisId = (String) json.get("redisId");
                entity.setId(IdWorker.getId());
                entity.setUuid(indexName+":"+redisId);
                KnowledgeEmbeddingPointsEntity en = new KnowledgeEmbeddingPointsEntity();
                en.setEmbeddingId(entity.getId());
                en.setUuid(indexName+":"+redisId);
                en.setContent(entity.getContent());
                en.setInitContent(entity.getContent());
                en.setVector(Arrays.toString(embedding.vector()));
                en.setSequence(1);
                en.setType(1);
                knowledgeEmbeddingPointsService.saveOrUpdate(en, false);
            }else if(2 == knowledgeBaseEntity.getKnowledgeType()) { // 表格知识库
                entity.setInitContent(content);
                entity.setSequence(maxSequence);
                QueryWrapper<KnowledgeItemTableIndexEntity> tableWrapper = new QueryWrapper<>();
                tableWrapper.eq("item_id", itemEntity.getId());
                List<KnowledgeItemTableIndexEntity> indexList = knowledgeItemTableIndexService.list(tableWrapper);
                String indexs = null;
                String titles = null;
                if(indexList!=null && indexList.size()>0){
                    indexs = indexList.get(0).getIndexs();
                    titles = indexList.get(0).getTitles();
                }else{
                    throw new BusinessException("为获取到该文档的索引信息，请先配置索引");
                }
                if(org.apache.commons.lang3.StringUtils.isBlank(indexs)){
                    throw new BusinessException("为获取到该文档的索引信息，请先配置索引");
                }
                if(org.apache.commons.lang3.StringUtils.isBlank(titles)){
                    throw new BusinessException("为获取到该文档的表头信息，请先确认上传文件的格式是否正确");
                }
                //表格型知识库
                String[] titlesArray = titles.split(",");
                String[] indexsArray = indexs.split(",");
                JSONObject ob = JSONObject.parseObject(content);
                String o = "";
                for(int j=0; j<titlesArray.length; j++){
                    o += (titlesArray[j] + ": " +ob.get(titlesArray[j]) + " ");
                }
                entity.setSliceState(1);
                entity.setContent(o);
                entity.setInitContent(content);
                knowledgeEmbeddingService.saveOrUpdate(entity, false);

                List allRedisIds = new ArrayList();
                try {
                    List<TextSegment> documents = new ArrayList<>();
                    List<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<>();
                    TextSegment s = TextSegment.from(o);
                    documents.add(s);
                    for(int j=0; j<indexsArray.length; j++){
                        String index = indexsArray[j];
                        documents.add(TextSegment.from(index+": "+ob.getString(index)));
                    }
                    //执行文件切分
                    JSONObject json = documentSplitUtil.documentStoreList(documents, embeddingModel, embeddingStore);
                    List embeddings = (List) json.get("embeddings");
                    allRedisIds = (List) json.get("redisIds");
                    for(int j=0; j<documents.size(); j++){
                        TextSegment segment = documents.get(j);
                        Embedding embedding = (Embedding) embeddings.get(j);
                        String id = (String) allRedisIds.get(j);

                        KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                        p.setEmbeddingId(entity.getId());
                        p.setUuid(indexName+":"+id);
                        p.setContent(segment.text());
                        p.setInitContent(segment.text());
                        p.setVector(Arrays.toString(embedding.vector()));
                        p.setType(1);
                        p.setSequence(documents.size()-j);
                        listPoints.add(p);
                    }

                    if(listPoints!=null && listPoints.size()>0){
                        knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                    }
                }catch (Exception e){
                    //删除生成的向量数据库信息
                    embeddingStore.removeAll(allRedisIds);
                    throw new BusinessException("生成向量数据库信息失败");
                }
            }
            JSONObject re = new JSONObject();
            re.put("id", entity.getId());
            re.put("content", content);
            chunkInfo.add(re);
        }
        Integer embeddingCount = knowledgeEmbeddingPointsService.countEmbeddingByItemId(itemEntity.getId());
        itemEntity.setEmbeddingCount(embeddingCount);
        knowledgeItemService.saveOrUpdate(itemEntity, false);

        ChunkResult result = new ChunkResult();
        result.setChunkInfo(chunkInfo);
        return CommonResponse.success(result);
    }

    /**
     * 修改切片
     *
     * @return
     */
    @RequestMapping(value = "/updateChunk", method = RequestMethod.POST)
    public CommonResponse<ChunkResult> updateChunk(@RequestBody UpdateChunkParam updateChunkParam) {
        String content = updateChunkParam.getChunkContent();
        if(StringUtils.isBlank(content)){
            throw new BusinessException("内容不能为空");
        }
        KnowledgeEmbeddingEntity embeddingEntity = knowledgeEmbeddingService.selectById(updateChunkParam.getChunkId());
        if(embeddingEntity == null) {
            throw new BusinessException("知识切片不存在");
        }
        KnowledgeBaseEntity knowledgeBaseEntity = knowledgeBaseService.queryBaseDataByEmbeddingId(embeddingEntity.getId());
        String indexName = knowledgeBaseEntity.getCode();

        EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
        //// 删除向量数据库中的信息
        EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
        if(1 == knowledgeBaseEntity.getKnowledgeType()) { //文本知识库
            embeddingEntity.setInitContent(content);
            embeddingEntity.setContent(content);
            embeddingEntity.setType(3);
            //获取自动切片的知识点，并且修改一下向量数据信息
            QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("embedding_id", embeddingEntity.getId());
            wrapper.in("type", 1,3);
            List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
            if(list!=null && list.size()>0){
                KnowledgeEmbeddingPointsEntity en = list.get(0);
                embeddingStore.remove(en.getUuid());
                //执行文件切分
                JSONObject json = documentSplitUtil.documentStoreSingle(content, embeddingModel, embeddingStore);
                Embedding embedding = (Embedding) json.get("embedding");
                String redisId = (String) json.get("redisId");
                embeddingEntity.setUuid(indexName+":"+redisId);
                en.setUuid(indexName+":"+redisId);
                en.setContent(content);
                en.setVector(Arrays.toString(embedding.vector()));
                knowledgeEmbeddingPointsService.saveOrUpdate(en, false);
            }else{
                //执行文件切分
                JSONObject json = documentSplitUtil.documentStoreSingle(content, embeddingModel, embeddingStore);
                Embedding embedding = (Embedding) json.get("embedding");
                String redisId = (String) json.get("redisId");
                embeddingEntity.setUuid(indexName+":"+redisId);
                KnowledgeEmbeddingPointsEntity en = new KnowledgeEmbeddingPointsEntity();
                en.setEmbeddingId(embeddingEntity.getId());
                en.setUuid(indexName+":"+redisId);
                en.setContent(embeddingEntity.getContent());
                en.setInitContent(embeddingEntity.getContent());
                en.setVector(Arrays.toString(embedding.vector()));
                en.setSequence(1);
                en.setType(1);
                knowledgeEmbeddingPointsService.saveOrUpdate(en, false);
            }
            knowledgeEmbeddingService.saveOrUpdate(embeddingEntity, false);
        }else if(2 == knowledgeBaseEntity.getKnowledgeType()) { // 表格知识库
            embeddingEntity.setInitContent(content);
            QueryWrapper<KnowledgeItemTableIndexEntity> tableWrapper = new QueryWrapper<>();
            tableWrapper.eq("item_id", embeddingEntity.getItemId());
            List<KnowledgeItemTableIndexEntity> indexList = knowledgeItemTableIndexService.list(tableWrapper);
            String indexs = null;
            String titles = null;
            if(indexList!=null && indexList.size()>0){
                indexs = indexList.get(0).getIndexs();
                titles = indexList.get(0).getTitles();
            }else{
                throw new BusinessException("为获取到该文档的索引信息，请先配置索引");
            }
            if(org.apache.commons.lang3.StringUtils.isBlank(indexs)){
                throw new BusinessException("为获取到该文档的索引信息，请先配置索引");
            }
            if(org.apache.commons.lang3.StringUtils.isBlank(titles)){
                throw new BusinessException("为获取到该文档的表头信息，请先确认上传文件的格式是否正确");
            }

            QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("embedding_id", embeddingEntity.getId());
            wrapper.in("type", 1,3);
            List<KnowledgeEmbeddingPointsEntity> list = knowledgeEmbeddingPointsService.list(wrapper);
            if(list!=null && list.size()>0){
                List<String> delredisIds = new ArrayList<>();
                list.forEach(e -> {
                    delredisIds.add(e.getUuid());
                });
                embeddingStore.removeAll(delredisIds);
                knowledgeEmbeddingPointsService.remove(wrapper);
            }

            //表格型知识库
            String[] titlesArray = titles.split(",");
            String[] indexsArray = indexs.split(",");
            JSONObject ob = JSONObject.parseObject(content);
            String o = "";
            for(int j=0; j<titlesArray.length; j++){
                o += (titlesArray[j] + ": " +ob.get(titlesArray[j]) + " ");
            }
            embeddingEntity.setSliceState(1);
            embeddingEntity.setContent(o);
            embeddingEntity.setInitContent(content);
            knowledgeEmbeddingService.saveOrUpdate(embeddingEntity, false);

            List allRedisIds = new ArrayList();
            try {
                List<TextSegment> documents = new ArrayList<>();
                List<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<>();
                TextSegment s = TextSegment.from(o);
                documents.add(s);
                for(int j=0; j<indexsArray.length; j++){
                    String index = indexsArray[j];
                    documents.add(TextSegment.from(index+": "+ob.getString(index)));
                }
                //执行文件切分
                JSONObject json = documentSplitUtil.documentStoreList(documents, embeddingModel, embeddingStore);
                List embeddings = (List) json.get("embeddings");
                allRedisIds = (List) json.get("redisIds");
                for(int j=0; j<documents.size(); j++){
                    TextSegment segment = documents.get(j);
                    Embedding embedding = (Embedding) embeddings.get(j);
                    String id = (String) allRedisIds.get(j);

                    KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                    p.setEmbeddingId(embeddingEntity.getId());
                    p.setUuid(indexName+":"+id);
                    p.setContent(segment.text());
                    p.setInitContent(segment.text());
                    p.setVector(Arrays.toString(embedding.vector()));
                    p.setType(1);
                    p.setSequence(documents.size()-j);
                    listPoints.add(p);
                }

                if(listPoints!=null && listPoints.size()>0){
                    knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                }
            }catch (Exception e){
                //删除生成的向量数据库信息
                embeddingStore.removeAll(allRedisIds);
                throw new BusinessException("生成向量数据库信息失败");
            }
        }

        ChunkResult result = new ChunkResult();
        List<JSONObject> chunkInfo = new ArrayList<>();
        JSONObject re = new JSONObject();
        re.put("id", updateChunkParam.getChunkId());
        re.put("content", content);
        chunkInfo.add(re);
        result.setChunkInfo(chunkInfo);
        return CommonResponse.success(result);
    }

    /**
     * 删除切片
     *
     * @return
     */
    @RequestMapping(value = "/deleteChunk", method = RequestMethod.POST)
    public CommonResponse<String> deleteChunk(@RequestBody Long chunkId) {
        knowledgeEmbeddingService.delData(chunkId);
        return CommonResponse.success("删除成功！");
    }

}
