package com.ejianc.foundation.ai.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.ai.bean.*;
import com.ejianc.foundation.ai.config.EjcAiEmbeding;
import com.ejianc.foundation.ai.mapper.KnowledgeItemTableIndexMapper;
import com.ejianc.foundation.ai.service.*;
import com.ejianc.foundation.ai.utils.DocumentSplitUtil;
import com.ejianc.foundation.ai.vo.KnowledgeItemTableIndexVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * AI知识库
 * 
 * @author generator
 * 
 */
@Service("knowledgeItemTableIndexService")
public class KnowledgeItemTableIndexServiceImpl extends BaseServiceImpl<KnowledgeItemTableIndexMapper, KnowledgeItemTableIndexEntity> implements IKnowledgeItemTableIndexService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IKnowledgeItemService itemService;
    @Autowired
    private DocumentSplitUtil documentSplitUtil;
    @Autowired
    private EjcAiEmbeding ejcAiEmbeding;
    @Autowired
    private IKnowledgeEmbeddingService knowledgeEmbeddingService;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IKnowledgeEmbeddingPointsService knowledgeEmbeddingPointsService;

    @Override
    public void configTableIndex(KnowledgeItemTableIndexVO vo) {
        KnowledgeItemTableIndexEntity old = this.selectById(vo.getId());

        KnowledgeBaseEntity knowledgeBase = knowledgeBaseService.queryBaseDataByItemId(old.getItemId());
        String indexName = knowledgeBase.getCode();

        if(StringUtils.isNotBlank(old.getIndexs())){
            //重置索引，删除原先自动生成的索引切片信息
            QueryWrapper<KnowledgeEmbeddingEntity> wrapperEmbedding = new QueryWrapper<>();
            wrapperEmbedding.eq("item_id", vo.getItemId());
            wrapperEmbedding.in("type", 1,3);
            List<KnowledgeEmbeddingEntity> items = knowledgeEmbeddingService.list(wrapperEmbedding);
            if(items!=null && items.size()>0){
                List<Long> embeddingIds = new ArrayList<>();
                items.forEach(item -> {
                    embeddingIds.add(item.getId());
                });
                QueryWrapper<KnowledgeEmbeddingPointsEntity> wrapperEmbeddingPoints = new QueryWrapper<>();
                wrapperEmbeddingPoints.in("embedding_id", embeddingIds);
                wrapperEmbeddingPoints.in("type", 1,3);
                List<KnowledgeEmbeddingPointsEntity> points = knowledgeEmbeddingPointsService.list(wrapperEmbeddingPoints);
                if(points!=null && points.size()>0){
                    List<String> rids = new ArrayList<>();
                    points.forEach(item -> {
                        rids.add(item.getUuid());
                    });
                    EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
                    embeddingStore.removeAll(rids);
                }
                knowledgeEmbeddingService.remove(wrapperEmbedding);
                knowledgeEmbeddingPointsService.remove(wrapperEmbeddingPoints);
            }
        }
        KnowledgeItemEntity itemEntity = itemService.selectById(vo.getItemId());
        if(StringUtils.isBlank(vo.getIndexs())){
            throw new BusinessException("索引字段不能为空");
        }
        String[] indexs = vo.getIndexs().split(",");
        itemEntity.setEmbeddingStatus(2);
        itemService.saveOrUpdate(itemEntity, false);

        KnowledgeItemTableIndexEntity entity = BeanMapper.map(vo, KnowledgeItemTableIndexEntity.class);
        this.saveOrUpdate(entity, false);

        Map<String, Object> invocationInfo = new HashMap<>();
        invocationInfo.put("authority", InvocationInfoProxy.getExtendAttribute("authority"));
        invocationInfo.put("callid", InvocationInfoProxy.getCallid());
        invocationInfo.put("tenantid", InvocationInfoProxy.getTenantid());
        invocationInfo.put("employeeId", InvocationInfoProxy.getEmployeeId());
        invocationInfo.put("locale", InvocationInfoProxy.getLocale());
        invocationInfo.put("logints", InvocationInfoProxy.getLogints());
        invocationInfo.put("orgId", InvocationInfoProxy.getOrgId());
        invocationInfo.put("sysid", InvocationInfoProxy.getSysid());
        invocationInfo.put("theme", InvocationInfoProxy.getTheme());
        invocationInfo.put("timeZone", InvocationInfoProxy.getTimeZone());
        invocationInfo.put("usercode", InvocationInfoProxy.getUsercode());
        invocationInfo.put("userid", InvocationInfoProxy.getUserid());
        invocationInfo.put("userType", InvocationInfoProxy.getUserType());

        Runnable task = () -> {
            InvocationInfoProxy.setCallid(invocationInfo.get("callid")!=null?invocationInfo.get("callid").toString():null);
            InvocationInfoProxy.setTenantid(invocationInfo.get("tenantid")!=null?Long.parseLong(invocationInfo.get("tenantid").toString()):null);
            InvocationInfoProxy.setEmployeeId(invocationInfo.get("employeeId")!=null?Long.parseLong(invocationInfo.get("employeeId").toString()):null);
            InvocationInfoProxy.setLocale(invocationInfo.get("locale")!=null?invocationInfo.get("locale").toString():null);
            InvocationInfoProxy.setLogints(invocationInfo.get("logints")!=null?invocationInfo.get("logints").toString():null);
            InvocationInfoProxy.setOrgId(invocationInfo.get("orgId")!=null?Long.parseLong(invocationInfo.get("orgId").toString()):null);
            InvocationInfoProxy.setSysid(invocationInfo.get("sysid")!=null?invocationInfo.get("sysid").toString():null);
            InvocationInfoProxy.setTheme(invocationInfo.get("theme")!=null?invocationInfo.get("theme").toString():null);
            InvocationInfoProxy.setTimeZone(invocationInfo.get("timeZone")!=null?invocationInfo.get("timeZone").toString():null);
            InvocationInfoProxy.setUsercode(invocationInfo.get("usercode")!=null?invocationInfo.get("usercode").toString():null);
            InvocationInfoProxy.setUserid(invocationInfo.get("userid")!=null?Long.parseLong(invocationInfo.get("userid").toString()):null);
            InvocationInfoProxy.setUserType(invocationInfo.get("userType")!=null?invocationInfo.get("userType").toString():null);

            InvocationInfoProxy.setExtendAttribute("authority", invocationInfo.get("authority")!=null?invocationInfo.get("authority").toString():null);

            List<String> allRedisIds = new ArrayList<>();
            try {
                //加载文件内容
                Document document = documentSplitUtil.loadDocument(itemEntity.getFileSuffix(), itemEntity.getFilePath());
                //表格型知识库
                String[] allText = document.text().split("\n");
                String[] titles = null;
                Integer embeddingCount = 0;
                for(int i=1; i<allText.length; i++){
                    List<TextSegment> documents = new ArrayList<>();
                    List<KnowledgeEmbeddingEntity> embeddingEntitys = new ArrayList<>();
                    List<KnowledgeEmbeddingPointsEntity> listPoints = new ArrayList<>();
                    String lineData = allText[i];
                    String[] items = lineData.split("\t");
                    if(i==1){
                        titles = items;
                    }else{
                        //具体数据
                        JSONObject ob = new JSONObject();
                        String o = "";
                        for(int j=0; j<items.length; j++){
                            o += (titles[j] + ": " +items[j] + " ");
                            ob.put(titles[j], items[j]);
                        }
                        TextSegment s = TextSegment.from(o);
                        documents.add(s);
                        Long embeddingId = IdWorker.getId();

                        KnowledgeEmbeddingEntity embeddingEntity = new KnowledgeEmbeddingEntity();
                        embeddingEntity.setItemId(itemEntity.getId());
                        embeddingEntity.setId(embeddingId);
                        embeddingEntity.setType(1);
                        embeddingEntity.setSliceState(1);
                        embeddingEntity.setContent(o);
                        embeddingEntity.setInitContent(ob.toJSONString());
                        embeddingEntity.setTableContent(ob.toJSONString());
                        embeddingEntity.setSequence(allText.length-1-i);
                        embeddingEntitys.add(embeddingEntity);

                        for(int j=0; j<indexs.length; j++){
                            String index = indexs[j];
                            documents.add(TextSegment.from(index+": "+ob.getString(index)));
                        }

                        EmbeddingModel embeddingModel = ejcAiEmbeding.getEmbeddingModel(indexName);
                        //// 删除向量数据库中的信息
                        EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);

                        //执行文件切分
                        JSONObject json = documentSplitUtil.documentStoreList(documents, embeddingModel, embeddingStore);

                        List embeddings = (List) json.get("embeddings");
                        List redisIds = (List) json.get("redisIds");
                        allRedisIds.addAll(redisIds);
                        for(int j=0; j<documents.size(); j++){
                            TextSegment segment = documents.get(j);
                            Embedding embedding = (Embedding) embeddings.get(j);
                            String id = (String) redisIds.get(j);

                            KnowledgeEmbeddingPointsEntity p = new KnowledgeEmbeddingPointsEntity();
                            p.setEmbeddingId(embeddingId);
                            p.setUuid(indexName+":"+id);
                            p.setContent(segment.text());
                            p.setInitContent(segment.text());
                            p.setVector(Arrays.toString(embedding.vector()));
                            p.setType(1);
                            p.setSequence(documents.size()-j);
                            listPoints.add(p);
                        }

                    }
                    if(embeddingEntitys!=null && embeddingEntitys.size()>0){
                        knowledgeEmbeddingService.saveOrUpdateBatch(embeddingEntitys, embeddingEntitys.size(), false);
                    }
                    if(listPoints!=null && listPoints.size()>0){
                        knowledgeEmbeddingPointsService.saveOrUpdateBatch(listPoints, listPoints.size(), false);
                    }
                    embeddingCount += listPoints.size();
                }
                itemEntity.setEmbeddingStatus(3);
                itemEntity.setEmbeddingCount(embeddingCount);
                itemService.saveOrUpdate(itemEntity, false);
            }catch (Exception e){
                logger.error("生成向量数据库信息失败：{}",e);
                itemEntity.setEmbeddingStatus(4);
                itemService.saveOrUpdate(itemEntity, false);
                //删除生成的向量数据库信息
                EmbeddingStore<TextSegment> embeddingStore = ejcAiEmbeding.getEmbeddingStore(indexName);
                embeddingStore.removeAll(allRedisIds);
                throw new BusinessException("生成向量数据库信息失败");
            }
        };
        new Thread(task).start();
    }
}
