package com.ejianc.foundation.ai.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.ai.mapper.KnowledgeMessageMapper;
import com.ejianc.foundation.ai.bean.KnowledgeMessageEntity;
import com.ejianc.foundation.ai.service.IKnowledgeMessageService;

import java.util.List;

/**
 * AI知识库对话消息表
 * 
 * @author generator
 * 
 */
@Service("knowledgeMessageService")
public class KnowledgeMessageServiceImpl extends BaseServiceImpl<KnowledgeMessageMapper, KnowledgeMessageEntity> implements IKnowledgeMessageService{

    @Autowired
    private KnowledgeMessageMapper knowledgeMessageMapper;

    @Override
    public KnowledgeMessageEntity queryParentHistoryList(Long dialogId, Long userId, Long knowledgeMessageId) {
        KnowledgeMessageEntity messageEntity = knowledgeMessageMapper.queryParentHistoryList(dialogId, userId, knowledgeMessageId);
        return messageEntity;
    }
}
