package com.ejianc.langchain.documentSplit;

import com.ejianc.support.idworker.util.IdWorker;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.loader.FileSystemDocumentLoader;
import dev.langchain4j.data.document.loader.UrlDocumentLoader;
import dev.langchain4j.data.document.parser.TextDocumentParser;
import dev.langchain4j.data.document.parser.apache.poi.ApachePoiDocumentParser;
import dev.langchain4j.data.document.splitter.DocumentByLineSplitter;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.onnx.allminilml6v2.AllMiniLmL6V2EmbeddingModel;
import dev.langchain4j.rag.AugmentationRequest;
import dev.langchain4j.rag.AugmentationResult;
import dev.langchain4j.rag.DefaultRetrievalAugmentor;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.rag.content.injector.ContentInjector;
import dev.langchain4j.rag.content.injector.DefaultContentInjector;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.rag.content.retriever.EmbeddingStoreContentRetriever;
import dev.langchain4j.rag.query.Metadata;
import dev.langchain4j.rag.query.transformer.DefaultQueryTransformer;
import dev.langchain4j.rag.query.transformer.QueryTransformer;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.EmbeddingStoreIngestor;
import dev.langchain4j.store.embedding.redis.RedisEmbeddingStore;
import okhttp3.MediaType;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;


/**
 * 作者 mrsir
 * 日期 2024/5/17
 * 包路径 com.ejianc.support.webpush.largeModel.qianfan
 */
public class DocumentSplitUtil {


    private static final MediaType mediaType = MediaType.parse("application/json");

    public Document loadDocument() {
        Document result = null;
        result = UrlDocumentLoader.load("C:/Users/Think/Desktop/test.txt", new TextDocumentParser());
//        if (storageLocation == AdiConstant.STORAGE_LOCATION_LOCAL) {
//            if (ext.equalsIgnoreCase("txt")) {
//                result = FileSystemDocumentLoader.loadDocument(path, new TextDocumentParser());
//            } else if (ext.equalsIgnoreCase("pdf")) {
//                result = FileSystemDocumentLoader.loadDocument(path, new ApachePdfBoxDocumentParser());
//            } else if (ArrayUtils.contains(POI_DOC_TYPES, adiFile.getExt())) {
//                result = FileSystemDocumentLoader.loadDocument(path, new ApachePoiDocumentParser());
//            }
//        } else {
//            if (ext.equalsIgnoreCase("txt")) {
//                result = UrlDocumentLoader.load(path, new TextDocumentParser());
//            } else if (ext.equalsIgnoreCase("pdf")) {
//                result = UrlDocumentLoader.load(path, new ApachePdfBoxDocumentParser());
//            } else if (ArrayUtils.contains(POI_DOC_TYPES, adiFile.getExt())) {
//                result = UrlDocumentLoader.load(path, new ApachePoiDocumentParser());
//            }
//        }
        return result;
    }

    private static Document getDocument(URL resource) {
        Document document = null;
        try{
            Path path = Paths.get(resource.toURI());
            document = FileSystemDocumentLoader.loadDocument(path);
        }catch (URISyntaxException e){
//            log.error("加载文件发生异常", e);
        }
        return document;
    }
    public static void main(String[] args) throws Exception{
//        DocumentByCharacterSplitter documentSplitter = new DocumentByCharacterSplitter(100, 10);
        DocumentByLineSplitter documentSplitter = new DocumentByLineSplitter(200, 10);

        Document de = null;
//        Document de = null;
        de = UrlDocumentLoader.load("https://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/999999/202503/1895749570685034498.docx", new ApachePoiDocumentParser());
//        String text = "这是一个需要被分割的文本。";
//        List<TextSegment> documents = splitter.split(de);
//
//        System.out.println("documents: " + documents);


//        de = UrlDocumentLoader.load("https://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/999999/202502/1892825319707500546.txt", new TextDocumentParser());
//        de = UrlDocumentLoader.load("https://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/999999/202502/1892832659437510657.pdf", new ApachePdfBoxDocumentParser());
//        de = UrlDocumentLoader.load("https://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/999999/202503/1896762077230915585.xlsx", new ApachePoiDocumentParser());
//        System.out.println("sss");
//        URL url = new URL("https://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/999999/202502/1892535057827487745.txt");
//        Document de = getDocument(url);
//        DocumentSplitter documentSplitter = DocumentSplitters.recursive(300, 10);
//        List<TextSegment> ss = documentSplitter.split(de);//切分

        //AllMiniLmL6V2EmbeddingModel（通常表示为all-MiniLM-L6-v2）是一个基于MiniLM架构的句子嵌入模型，以下是对该模型的详细介绍：
        //all-MiniLM-L6-v2模型能够将句子和短段落映射到384维的稠密向量空间中，这些向量保留了文本的语义信息，使得模型能够用于各种NLP任务，如信息检索、聚类、语义搜索和句子相似度计算等。
        EmbeddingModel embeddingModel = new AllMiniLmL6V2EmbeddingModel();

//        Response<Embedding> embed = embeddingModel.embed("你好，我叫gorgor");
//        System.out.println(embed.content().toString());
//        System.out.println(embed.content().vector().length);

        //// 创建一个内存中的嵌入存储
//        EmbeddingStore<TextSegment> embeddingStore = new InMemoryEmbeddingStore<>();
        EmbeddingStore<TextSegment> embeddingStore = RedisEmbeddingStore.builder().host("47.93.115.124").port(6379).user("default").password("17Liancloud").dimension(384).indexName("test").build();;
//        EmbeddingStore<TextSegment> embeddingStore = new MongoDbEmbeddingStore();
        // DocumentSplitter documentSplitter：用于切割文档的分词器
        // EmbeddingModel embeddingModel：用于向量化的嵌入模型
        // EmbeddingStore embeddingStore：用于存储向量数据的向量数据库
        EmbeddingStoreIngestor embeddingStoreIngestor = EmbeddingStoreIngestor.builder()
                .documentSplitter(documentSplitter)
                .embeddingModel(embeddingModel)
                .embeddingStore(embeddingStore)
                .build();

        //多个文件进行切片并加载
//        List<Document> ds = new ArrayList<>();
//        embeddingStoreIngestor.ingest(ds);

        embeddingStoreIngestor.ingest(de);
//        embeddingModel.embed();

// 创建全量查询向量（如零向量）
        float[] dummyQueryVector = new float[384]; // 假设维度为384
        Arrays.fill(dummyQueryVector, 0f);

// 执行全量搜索（maxResults设为极大值）
        List<EmbeddingMatch<TextSegment>> allMatches =
                embeddingStore.findRelevant(Embedding.from(dummyQueryVector), Integer.MAX_VALUE, 0.0f);

// 遍历结果
        allMatches.forEach(match -> {
            TextSegment segment = match.embedded();
            match.embedding();
//            System.out.println(segment.text());
            System.out.println(Arrays.toString(match.embedding().vector()));
        });
// 用户查询
        String userQuery = "新建调度任务";
        // 创建内容注入器
        ContentInjector contentInjector = DefaultContentInjector.builder()
//                .metadataKeysToInclude(List.of("file_name", "index")) // 根据需要包含元数据键
                .build();

        // 创建查询转换器（这里使用默认实现，不做任何处理）
        QueryTransformer queryTransformer = new DefaultQueryTransformer();

        // 注意：QueryRouter在LangChain4j中可能不是直接作为DefaultRetrievalAugmentor的构造参数，
        // 而是根据查询类型或特征在内部逻辑中动态选择ContentRetriever。
        // 如果需要自定义路由逻辑，你可能需要在ContentRetriever的实现中处理。

//      创建Retrieval Augmentor（这里使用默认实现）
        ContentRetriever contentRetriever = EmbeddingStoreContentRetriever.builder()
                .embeddingStore(embeddingStore)
                .embeddingModel(embeddingModel)
                .build();

        // 创建DefaultRetrievalAugmentor
        RetrievalAugmentor retrievalAugmentor = DefaultRetrievalAugmentor.builder()
                .contentRetriever(contentRetriever)
                .contentInjector(contentInjector)
                .queryTransformer(queryTransformer) // 如果需要自定义查询转换逻辑
                .build();

        // 创建聊天语言模型（例如，使用OpenAI的ChatGPT）
//        ChatLanguageModel chatLanguageModel = OpenAiChatModel.builder()
//                .apiKey("YOUR_OPENAI_API_KEY") // 替换为你的OpenAI API密钥
//                .baseUrl("https://api.openai.com/v1") // OpenAI API的基础URL
//                .build();

//      将用户查询转换为AugmentationRequest
        UserMessage userMessage = new UserMessage(userQuery);
        Object memoryId = IdWorker.getId();
        List<ChatMessage> chatMemory = null;//上下文历史记录
        Metadata metadata = Metadata.from(userMessage, memoryId, chatMemory);
        AugmentationRequest augmentationRequest = new AugmentationRequest(userMessage,metadata);

//      使用Retrieval Augmentor进行扩充
        AugmentationResult augmentationResult = retrievalAugmentor.augment(augmentationRequest);

//      从AugmentationResult中获取扩充后的UserMessage
        UserMessage augmentedUserMessage = (UserMessage) augmentationResult.chatMessage();

        System.out.println("augmentedUserMessage: " + augmentedUserMessage);
//      假设ContentRetriever已经检索到相关内容，并将其注入到augmentedUserMessage中
//      这里我们模拟一下检索到的内容
        String retrievedContent = "The capital of France is Paris.";

//      将检索到的内容返回给用户（这里只是简单打印出来）
        System.out.println("Retrieved Content: " + retrievedContent);


//      在实际应用中，你可能会将检索到的内容传递给生成模型（如GPT），以生成更完整的回答

//        System.out.println(ss.get(0).text());
    }
}
