/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.ai.bean.ExtDictEntity;
import com.ejianc.foundation.ai.bean.KnowledgeBaseEntity;
import com.ejianc.foundation.ai.service.IExtDictRelationService;
import com.ejianc.foundation.ai.service.IExtDictService;
import com.ejianc.foundation.ai.service.IKnowledgeBaseService;
import com.ejianc.foundation.ai.vo.ExtDictVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"extDict"})
public class ExtDictController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExtDictService service;
    @Autowired
    private IKnowledgeBaseService knowledgeBaseService;
    @Autowired
    private IExtDictRelationService extDictRelationService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExtDictVO> saveOrUpdate(@RequestBody ExtDictVO saveOrUpdateVO) {
        ExtDictEntity entity = (ExtDictEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ExtDictEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setField(saveOrUpdateVO.getField());
            entity.setKnowledgeBaseId(saveOrUpdateVO.getKnowledgeBaseId());
            entity.setKnowledgeBaseCode(saveOrUpdateVO.getKnowledgeBaseCode());
            this.service.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        ExtDictEntity uniqueBean = (ExtDictEntity)((Object)this.service.selectById(entity.getId()));
        entity.setField(saveOrUpdateVO.getField());
        entity.setKnowledgeBaseId(saveOrUpdateVO.getKnowledgeBaseId());
        entity.setKnowledgeBaseCode(saveOrUpdateVO.getKnowledgeBaseCode());
        this.service.saveOrUpdate((Object)uniqueBean, false);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExtDictVO> queryDetail(Long id) {
        ExtDictEntity entity = (ExtDictEntity)((Object)this.service.selectById(id));
        ExtDictVO vo = (ExtDictVO)((Object)BeanMapper.map((Object)((Object)entity), ExtDictVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.service.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExtDictVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("field");
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExtDictVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryExtDictRefList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ExtDictVO>> queryKnowledgeBaseRefList(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText, @RequestParam int pageSize, @RequestParam int pageNumber, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchObject) {
        JSONObject _con;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("field");
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"pointsId") != null) {
            Long pointsId = _con.getLong("pointsId");
            KnowledgeBaseEntity en = this.knowledgeBaseService.queryBaseDataByPointsId(pointsId);
            queryParam.getParams().put("knowledgeBaseId", new Parameter("eq", (Object)en.getId()));
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"embedding_id", (Object)pointsId);
            List list = this.extDictRelationService.list((Wrapper)wrapper);
            ArrayList ids = new ArrayList();
            if (list != null && list.size() > 0) {
                list.forEach(item -> ids.add(item.getExtDictId()));
                queryParam.getParams().put("id", new Parameter("not_in", ids));
            }
        }
        IPage pageData = this.service.queryPage(queryParam);
        Page pageResult = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        if (pageData != null && pageData.getRecords() != null && pageData.getRecords().size() > 0) {
            List knowledgeVos = BeanMapper.mapList((Iterable)pageData.getRecords(), ExtDictVO.class);
            pageResult.setRecords(knowledgeVos);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", (Object)pageResult);
    }
}

